<?php

include_once '../sys/inc/start.php';
$doc = new document();
$doc->title = __('Чат - прихожая');

$listing = new listing();



$res = $db->prepare("SELECT COUNT(*) FROM `rooms` WHERE `group_show` <= ?");
$res->execute(Array($user->group));
$pages = new pages();
$pages->posts = $res->fetchColumn();

$q = $db->prepare("SELECT * FROM `rooms` WHERE `group_show` <= ? ORDER BY `position` ASC LIMIT " . $pages->limit);
$q->execute(Array($user->group));
while ($category = $q->fetch()) {
    $post = $listing->post();
    $post->url = "room.php?id=$category[id]";
    $post->title = text::toValue($category['name']);
    $post->icon('chat_mini');
    $post->post = text::for_opis($category['description']);
}

$listing->display(__('Нет доступных вам комнат или они еще не созданы'));

$pages->display('?'); // вывод страниц

if ($user->group >= 5) {
    $doc->act(__('Создать комнату'), 'rooms.new.php');
	$doc->act(__('Сортировка комнат'), 'rooms.sort.php');
	
    
}