<?php

include_once '../sys/inc/start.php';
$doc = new document();

$doc->title = __('Удаление комнаты');

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    header('Refresh: 1; url=./');
    $doc->err(__('Ошибка выбора комнаты'));
    $doc->ret(__('Чат прихожая'), './');
    exit;
}
$id_category = (int)$_GET['id'];

$q = $db->prepare("SELECT * FROM `rooms` WHERE `id` = ? AND `group_edit` <= ?");
$q->execute(Array($id_category, $user->group));

if (!$category = $q->fetch()) {
    header('Refresh: 1; url=./');
    $doc->err(__('Комната не доступна для удаления'));
    $doc->ret(__('Чат прихожая'), './');
    exit;
}

$doc->title = __('Удаление комнаты "%s"', $category['name']); // шапка страницы

if (isset($_POST['delete'])) {
    if (empty($_POST['captcha']) || empty($_POST['captcha_session']) || !captcha::check($_POST['captcha'], $_POST['captcha_session'])) {
        $doc->err(__('Проверочное число введено неверно'));
    } else {
        


        

        $res = $db->prepare("DELETE FROM `rooms` WHERE `id` = ? LIMIT 1");
        $res->execute(Array($category['id']));
		
		$res = $db->prepare("DELETE FROM `roms_message` WHERE `id_rooms` = ?");
        $res->execute(Array($category['id']));

        header('Refresh: 1; url=./');
        $dcms->log('Чат', 'Удаление комнаты "' . $category['name'] . '"');
        $doc->msg(__('Комната успешно удалена'));
        $doc->ret(__('Форум'), './');
        exit;
    }
}

$form = new form("?id=$category[id]&amp;" . passgen() . (isset($_GET['return']) ? '&amp;return=' . urlencode($_GET['return']) : null));
$form->captcha();
$form->bbcode('* ' . __('Все данные, относящиеся к данной комнаты будут безвозвратно удалены.'));
$form->button(__('Удалить'), 'delete');
$form->display();

$doc->act(__('Параметры комнаты'), 'rooms.edit.php?id=' . $category['id']);
$doc->ret(__('В комнату'), 'rooms.php?id=' . $category['id']);
$doc->ret(__('Чат прихожая'), './');
?>