<?php

include_once '../sys/inc/start.php';
$groups = groups::load_ini(); // загружаем массив групп
$doc = new document(4);
$doc->title = __('Редактирование комнаты');

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    header('Refresh: 1; url=./');
    $doc->err(__('Ошибка выбора комнаты'));
    exit;
}
$id_category = (int) $_GET['id'];

$q = $db->prepare("SELECT * FROM `rooms` WHERE `id` = ? AND `group_edit` <= ?");
$q->execute(Array($id_category, $user->group));
if (!$category = $q->fetch()) {
    header('Refresh: 1; url=./');
    $doc->err(__('Комнтата не доступна для редактирования'));
    exit;
}


if (isset($_POST['save'])) {
    if (isset($_POST['name']) && isset($_POST['description'])) {
        $name = text::for_name($_POST['name']);
        $description = text::input_text($_POST['description']);

        if ($name && $name != $category['name']) {
            $dcms->log('Чат', 'Изменение названия комнаты "' . $category['name'] . '" на [url=/betachat/room.php?id=' . $category['id'] . ']"' . $name . '"[/url]');
            $category['name'] = $name;
            $res = $db->prepare("UPDATE `rooms` SET `name` = ? WHERE `id` = ? LIMIT 1");
            $res->execute(Array($category['name'], $category['id']));
            $doc->msg(__('Название комнаты успешно изменено'));
        }

        if ($description != $category['description']) {
            $category['description'] = $description;
            $res = $db->prepare("UPDATE `rooms` SET `description` = ? WHERE `id` = ? LIMIT 1");
            $res->execute(Array($category['description'], $category['id']));
            $doc->msg(__('Описание комнаты успешно изменено'));
            $dcms->log('Чат', 'Изменение описания комнаты [url=/forum/category.php?id=' . $category['id'] . ']"' . $category['name'] . '"[/url]');
        }
    }

    if (isset($_POST['position'])) { // позиция
        $position = (int) $_POST['position'];
        if ($position != $category['position']) {
            $dcms->log('Чат', 'Изменение позиции комнаты [url=/betachat/room.php?id=' . $category['id'] . ']"' . $category['name'] . '"[/url] с ' . $category['position'] . ' на ' . $position);

            $category['position'] = $position;
            $res = $db->prepare("UPDATE `rooms` SET `position` = ? WHERE `id` = ? LIMIT 1");
            $res->execute(Array($category['position'], $category['id']));
            $doc->msg(__('Позиция комнаты успешно изменена'));
            $dcms->log('Чат', 'Изменение позиции комнаты [url=/betachat/room.php?id=' . $category['id'] . ']"' . $category['name'] . '"[/url] на ' . $position);
        }
    }

    if (isset($_POST['group_show'])) { // просмотр
        $group_show = (int) $_POST['group_show'];
        if (isset($groups[$group_show]) && $group_show != $category['group_show']) {
            $category['group_show'] = $group_show;
            $res = $db->prepare("UPDATE `rooms` SET `group_show` = ? WHERE `id` = ? LIMIT 1");
            $res->execute(Array($category['group_show'], $category['id']));
            $doc->msg(__('Просматривать комнату теперь разрешено группе "%s" и выше', groups::name($group_show)));
            $dcms->log('Чат', 'Изменение прав на просмотр комнаты [url=/betachat/room.php?id=' . $category['id'] . ']"' . $category['name'] . '"[/url] для группы ' . groups::name($group_show));
        }
    }


    if (isset($_POST['group_edit'])) { // редактирование
        $group_edit = (int) $_POST['group_edit'];
        if (isset($groups[$group_edit]) && $group_edit != $category['group_edit']) {
            if ($category['group_write'] > $group_edit)
                $doc->err(__('Для изменения параметров комнаты группе "%s" сначала необходимо дать права на создание разделов', groups::name($group_edit)));
            else {
                $category['group_edit'] = $group_edit;
                $res = $db->prepare("UPDATE `rooms` SET `group_edit` = ? WHERE `id` = ? LIMIT 1");
                $res->execute(Array($category['group_edit'], $category['id']));
                $doc->msg(__('Изменять параметры комнаты теперь разрешено группе "%s" и выше', groups::name($group_edit)));
                $dcms->log('Чат', 'Изменение прав на изменение параметров комнаты [url=/fbetachat/room.php?id=' . $category['id'] . ']"' . $category['name'] . '"[/url] для группы ' . groups::name($group_write));
            }
        }
    }
}

$doc->title = __('Редактирование комнаты "%s"', $category['name']); // шапка страницы

$form = new form("?id=$category[id]&amp;" . passgen() . (isset($_GET['return']) ? '&amp;return=' . urlencode($_GET['return']) : null));
$form->text('name', __('Название'), $category['name']);
$form->textarea('description', __('Описание'), $category['description']);
$form->text('position', __('Позиция'), $category['position']);

$options = array();
foreach ($groups as $type => $value)
    $options[] = array($type, $value['name'], $type == $category['group_show']);
$form->select('group_show', __('Просмотр комнаты'), $options);

$options = array();
foreach ($groups as $type => $value)
    $options[] = array($type, $value['name'], $type == $category['group_edit']);
$form->select('group_edit', __('Изменение параметров'), $options);

$form->bbcode('* ' . __('Будьте внимательнее при установке доступа выше своего.'));

$form->button(__('Применить'), 'save');
$form->display();

$doc->act(__('Удалить комнату'), 'rooms.delete.php?id=' . $category['id']);

if (isset($_GET['return']))
    $doc->ret(__('В комнату'), text::toValue($_GET['return']));
else
    $doc->ret(__('В комнату'), 'room.php?id=' . $category['id']);

$doc->ret(__('Чат'), './');
