<?php
require_once($_SERVER['DOCUMENT_ROOT'].'/system/App.php');

$dir = ROOT.'/uploads/tmp/';
$newDir = ROOT.'/uploads/';
$url = $core->hash(5);
$me['id'] = !empty($me) ? $me['id'] : null;
$formId = isset($_POST['form_id']) ? intval($_POST['form_id']) : null;
$guestHash = isset($_COOKIE['guest_hash']) && empty($me['id']) ? $sys->protect($_COOKIE['guest_hash']) : null;
$images = glob($dir.$formId."_*.{jpg,gif,png,jpeg,bmp}", GLOB_BRACE);

if(isset($_POST['form_id']))
{
	if(empty($images)) {
		$json = ['error' => '1', 'comment' => 'Изображения не выбраны'];
	}
	else
	{
		$albumId = Base::add('albums', ['time' => TIME, 'url' => $url, 'user_id' => $me['id'], 'guest_hash' => $guestHash]);
		foreach($images as $image) 
		{
			$name = basename($image);
			$newName = preg_replace('/(\d+)_/', '', $name, 1);
			
			$copy = rename($image, $newDir.$newName);

			if(!Base::update('photos', ['name' => $name], ['album_id' => $albumId, 'name' => $sys->protect($newName)]))
			{
				$json = ['error' => '1', 'comment' => 'Ошибка сохранения изображений'];
			} 
		}
	
		if(!empty($albumId) && $copy == true) {
			$checkAlbum = Base::get('albums', $albumId);
			$json = ['success' => '1', 'comment' => 'Альбом успешно создан', 'url' => HOME.'/a/'.$checkAlbum['url']];
		} else {
			$json = ['error' => '1', 'comment' => 'Ошибка создания альбома'];
		} 
		
	} 
} 
else
{
	$json = ['error' => '1', 'comment' => 'Пустое значение'];
}	

echo json_encode($json, JSON_UNESCAPED_UNICODE);	
