<?php
require_once $_SERVER['DOCUMENT_ROOT'].'/system/App.php';

if(isset($_POST) && $_SERVER['REQUEST_METHOD'] == 'POST')
{
    $id = (!empty($_POST['cat_id']) ? intval($_POST['cat_id']) : null);
    $cat = $gifts->getCatByID($id);
	$giftName = isset($_POST['name']) && !empty($_POST['name']) ? $sys->protect($_POST['name']) : null;
	$price = isset($_POST['price']) && !empty($_POST['price']) ? intval($_POST['price']) : 0; 
    
    if(empty($cat))
    {
        $json = array('error' => '1', 'comment' => 'Категория не найдена');
    }
    else if(empty($giftName))
    {
        $json = array('error' => '1', 'comment' => 'Введите название подарка');
    }
    else if($cat['type'] != 0 && empty($price))
    {
        $json = array('error' => '1', 'comment' => 'Введите цену подарка');
    }
    else if(empty($_FILES))
    {
        $json = array('error' => '1', 'comment' => 'Выберите изображение');
    }
    else
    {
        $uploaddir = ROOT.'/uploads/gift/'; 
    	if(!is_dir( $uploaddir)) mkdir( $uploaddir, 0777 );
    	
        $max = 5;
    	$files = $_FILES;
    	$type = ['jpg','gif','png','jpeg', 'bmp'];
    	
    	foreach($files as $value)
    	{
    		$name = $value['name'];
    		$new_name = preg_replace('/[^A-zА-яёЁ0-9\.]+/u', '', $name);
    		
        	$uptype = substr($name, strrpos($name, ".") + 1);
        	
        	if(!file_exists($value['tmp_name']))
        	{
        		$json = array('error' => '1', 'comment' => 'Выберите файл');
        	}
        	else if($value['size'] > (1048576 * $max))
        	{
        		$json = array('error' => '1', 'comment' => 'Вес файла должен быть не более '.$max.' мб');
        	}
        	else if(!in_array($uptype, $type))
        	{
        		$json = array('error' => '1', 'comment' => 'Файл данного формата выгружать запрещено');
        	}
        	else
        	{
                if(move_uploaded_file($value['tmp_name'], $uploaddir.$new_name))
    		    {
        			if(Base::add('gift', ['name' => $giftName, 'cat_id' => $cat['id'], 'price' => $price, 'image' => '/uploads/gift/'.$new_name]))
        			{
        				$json = array('success' => '1', 'comment' => 'Подарок успешно добавлен');
        			}
        			else
        			{
        				$json = array('error' => '1', 'comment' => 'Ошибка, подарок не был добавлен');
        			}
    		    }
    		    else
        		{
        			$json = array('error' => '1', 'comment' => 'Ошибка загрузки изображения');
        		}
        	}
        }
    }
}
else
{
	$json = array('error' => '1', 'comment' => 'Пустое значение');
}

echo json_encode($json, JSON_UNESCAPED_UNICODE);
?>