<?php
require_once($_SERVER['DOCUMENT_ROOT'].'/system/App.php');
	
if(isset($_SERVER['HTTP_X_REQUESTED_WITH']) && !empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest' && $_SERVER['REQUEST_METHOD'] == 'POST')
{
	$id       = isset($_POST['album_id']) && !empty($_POST['album_id']) ? intval($_POST['album_id']) : null;
	$path     = ROOT.'/uploads/';
	$getAlbum = !empty($id) ? $albums->getById($id) : null;
	
	if (empty($getAlbum))
	{
		$json = [
			'error' => 1, 
			'comment' => 'Альбом не найден'
		];
	}
	elseif ($getAlbum['user_id'] != $me['id'] && $me['access'] < 1)
	{
		$json = [
			'error' => 1, 
			'comment' => 'У вас недостаточно прав'
		];
	}
	else
	{
		if (Base::remove('albums', $id))
		{
			$json = [
				'success' => 1, 
				'comment' => 'Альбом успешно удалён', 
				'url' => HOME.'/albums'
			];
			
			$getPhotos = $albums->photosByID($id, 0, 250);
			
			if (!empty($getPhotos))
			{
				foreach ($getPhotos as $photoList)
				{
					if (!file_exsists($path.$photoList['name']) && !unlink($path.$photoList['name']) && !Base::remove('photos', $photoList['id']))
					{
						$json = [
							'error' => 1, 
							'comment' => 'Ошибка удаления изображения',
						];
					}
				}
			}
			
		}
		else
		{
			$json = [
				'error' => 1, 
				'comment' => 'Альбом не был удалён', 
			];
		}
		
	}
}
else
{
	$json = [
		'error' => 1, 
		'comment' => '404 Bad Request'
	];
}
echo json_encode($json, JSON_UNESCAPED_UNICODE);
