<?php
require_once($_SERVER['DOCUMENT_ROOT'].'/system/App.php');

if(isset($_POST))
{
    $id = (!empty($_POST['album_id']) ? intval($_POST['album_id']) : null);
	$album = $albums->getByID($id);
	$albumPhotos = $albums->photosByID($album['id']);
    $name = !empty(trim($_POST['zip_name'])) ? $sys->protect($_POST['zip_name']) : null;
    $dir = ROOT.'/uploads/';

    if(empty($album))
    {
        $json = ['error' => '1', 'comment' => 'Альбом не найден'];
    }
    else if(empty($name))
	{
		$json = ['error' => '1', 'comment' => 'Введите названия архива'];
	}
	else if(mb_strlen($name) < 3)
	{
		$json = ['error' => '1', 'comment' => 'Длина названия не должна быть короче 3 символов'];
	}
	else if(mb_strlen($name) > 30)
	{
		$json = ['error' => '1', 'comment' => 'Длина названия не должна превышать 30 символов'];
	}
    else if($me['access'] < 1 || $me['vip'] != 1)
    {
        $json = ['error' => '1', 'comment' => 'Данная функция доступна VIP-пользователям'];
    }
    else if(empty($albumPhotos) || count($albumPhotos) == 0)
    {
        $json = ['error' => '1', 'comment' => 'Альбом пуст'];
    }
    else if(file_exists($dir.'zip/'.$name.'.zip'))
    {
        $json = ['error' => '1', 'comment' => 'Такой архив уже существует'];
    }
    else
    {
    	
        if(!empty($albumPhotos))
        {
        	$files = false;
        
        	foreach($albumPhotos as $photo)
        	{
        		if (file_exists($dir.$photo['name'])) $files[] = $dir.$photo['name'];
        	}
        	
            $zip = $sys->createZip($files, $dir.'zip/'.$name.'.zip');
            
            if($zip != false)
            {
                $json = array('success' => '1', 'comment' => 'Архив успешно создан', 'url' => HOME.'/uploads/zip/'.$name.'.zip');
            }
        }
    }
}
else
{
	$json = array('error' => '1', 'comment' => 'Ошибка, пустое значение');
}	

echo json_encode($json, JSON_UNESCAPED_UNICODE);	
?>