<?php
require_once($_SERVER['DOCUMENT_ROOT'].'/system/App.php');

if(isset($_POST) && $_SERVER['REQUEST_METHOD'] == 'POST')
{
	$id = (!empty($_POST['album_id']) ? intval($_POST['album_id']) : null);
	$name = isset($_POST['name']) && !empty($_POST['name']) ? $sys->protect($_POST['name']) : null;
	
	$album = $albums->getByID($id);
	
	if(empty($album))
	{
		$json = array('error' => '1', 'comment' => 'Альбом не найден');
	}
    if(empty($name))
	{
		$json = array('error' => '1', 'comment' => 'Введите название альбома');
	}
	else if(empty($me) || $me['id'] != $album['user_id'] && $me['access'] < 1)
	{
		$json = ['error' => 1, 'comment' => 'У вас недостаточно прав для выполнения данной операции'];
	}
	else
    {
        if(!Base::update('albums', $id, ['name' => $name]))
    	{
    	    $json = array('error' => '1', 'comment' => 'Ошибка редактирования');
    	}
    	else
    	{
    	    $json = array('success' => '1', 'comment' => 'Альбом успешно отредактирован');
    	}
    }
} 
else
{
	$json = array('error' => '1', 'comment' => '404 Bad Request');
}	

echo json_encode($json, JSON_UNESCAPED_UNICODE);	
?>