<?php
require_once($_SERVER['DOCUMENT_ROOT'].'/system/App.php');
	
if ($sys->isAjax())
{
	$user_id = isset($_POST['id']) && !empty($_POST['id']) ? (int) $_POST['id'] : false;
	$message = isset($_POST['message']) && !empty($_POST['message']) ? $sys->protect($_POST['message']) : '';
	
	$checkUser = $user->InfoById($user_id, 'id');
	
	if (!$checkUser)
	{
		$json = [
			'error' => 1, 
			'comment' => 'Пользователь не найден',
		];
	}
	elseif (!$me)
	{
		$json = [
			'error' => 1, 
			'comment' => 'Авторизируйтесь для выполнения этого действия',
		];
	}
	elseif ($me['id'] == $user_id)
	{
		$json = [
			'error' => 1, 
			'comment' => 'Нельзя добавить самого себя в друзья'
		];
	}
	else
	{
		if ($friends->isSubscriber($user_id, $me['id']))
		{
			$json = [
				'error' => 1, 
				'comment' => 'Вы уже отправляли заявку ранее',
			];
		}
		elseif ($friends->isFriends($user_id, $me['id']))
		{
			$json = [
				'error' => 1, 
				'comment' => 'Вы и так друзья',
			];
		}
		elseif ($friends->isSubscriber($me['id'], $user_id))
		{
			if ($friends->acceptApplication($me['id'], $user_id))
			{
				$json = [
					'success' => 1, 
					'comment' => 'Пользователь успешно добавлен в друзья',
				];
			}
			else
			{
				$json = [
					'error' => 1, 
					'comment' => 'Пользователь не был добавлен в друзья',
				];
			}
		}
		else
		{
			if ($friends->add($me['id'], $user_id, $message))
			{
				$json = [
					'success' => 1, 
					'comment' => 'Заявка успешно отправлена',
				];
			}
			else
			{
				$json = [
					'error' => 1, 
					'comment' => 'Заявка не была отправлена',
				];
			}
		}
	}
}
else
{
	$json = [
		'error' => 1, 
		'comment' => '404 Bad Request'
	];
}
echo json_encode($json, JSON_UNESCAPED_UNICODE);
