<?php
require_once($_SERVER['DOCUMENT_ROOT'].'/system/App.php');
	
if ($sys->isAjax())
{
	$user_id = isset($_POST['id']) && !empty($_POST['id']) ? (int) $_POST['id'] : false;
	
	$checkUser = $user->InfoById($user_id, 'id');
	
	if (!$checkUser)
	{
		$json = [
			'error' => 1, 
			'comment' => 'Пользователь не найден',
		];
	}
	elseif (!$me)
	{
		$json = [
			'error' => 1, 
			'comment' => 'Авторизируйтесь для выполнения этого действия',
		];
	}
	elseif (!$friends->isSubscriber($me['id'], $user_id))
	{
		$json = [
			'error' => 1, 
			'comment' => 'Пользователь не подписан на вас',
		];
	}
	elseif ($friends->isFriends($me['id'], $user_id))
	{
		$json = [
			'error' => 1, 
			'comment' => 'Пользователь ваш друг',
		];
	}
	else
	{
		if ($friends->rejectApplication($me['id'], $user_id))
		{
			$json = [
				'success' => 1, 
				'comment' => 'Заявка успешно отклонена',
			];
		}
		else
		{
			$json = [
				'error' => 1, 
				'comment' => 'Заявка не была отклонена',
			];
		}
	}
}
else
{
	$json = [
		'error' => 1, 
		'comment' => '404 Bad Request'
	];
}
echo json_encode($json, JSON_UNESCAPED_UNICODE);
