﻿<?php
require_once($_SERVER['DOCUMENT_ROOT'].'/system/App.php');
	
if($sys->isAjax() && $_SERVER['REQUEST_METHOD'] == 'POST')
{
	$message = isset($_POST['message']) && !empty($_POST['message']) ? $sys->protect($_POST['message']) : null;
	
	if (!$me)
	{
		$json = [
			'error'   => 1, 
			'comment' => 'Войдите для выполнения данного действия',
		];
	}
	elseif (empty($message))
	{
		$json = [
			'error'   => 1, 
			'comment' => 'Введите сообщение',
		];
	}
	else
	{
		$files = $_FILES;
		$countFiles = count($files);

		if (empty($countFiles))
		{
			$json = [
				'error'   => 1,
				'comment' => 'Изображения не выбраны',
			];
		}
		elseif ($countFiles > $settings->max_files_to_download)
		{
			$json = [
				'error'   => 1,
				'comment' => 'Лимит на разовую загрузку - '.$settings->max_files_to_download,
			];
		}
		else
		{
			$maxSize   = 10;
			$uploadDir = '/uploads/attachs/'; 
			$arrTypes = [
				'gif',
				'jpg',
				'png',
				'jpeg', 
				'bmp',
			];
			
			$newsId = Base::add('news', [
				'time'    => TIME, 
				'message' => $message,
				'user_id' => $me['id'], 
			]);
			
			if (!empty($newsId))
			{
				
				
				foreach($files as $file)
				{
					$name       = $file['name'];
					$uploadType = substr($name, strrpos($name, ".") + 1);
					$newName    = $_SERVER['HTTP_HOST'].'_attach_'.$core->hash(5).'.'.$uploadType;
					
					if ($file['size'] > (1048576 * $maxSize))
					{
						$json = [
							'error'   => 1,
							'comment' => 'Вес изображения не должен превышать '.$maxSize.' мб',
						];
					}
					elseif (!in_array($uploadType, $arrTypes))
	        		{
						$json = [
							'error'   => 1, 
							'comment' => 'Файл данного формата выгружать запрещено',
						];
	        		}
	        		else
	        		{
	        			
	        			if (!move_uploaded_file($file['tmp_name'], ROOT.$uploadDir.$newName) || !Base::add('news_files', ['url' => HOME.$uploadDir.$newName, 'time' => TIME, 'user_id' => $me['id'], 'news_id' => $newsId]))
	        			{
	        				$json = [
								'error'   => 1,
								'comment' => 'Ошибка загрузки изображения',
							];
	        			}
						else
						{
							$json = [
								'success' => 1,
								'comment' => 'Запись добавлена',
								'url'     => HOME.'/news',
							];
						}
	        		}	
				}
			}		
			else
			{
				$json = [
					'error'   => 1,
					'comment' => 'Ошибка добавления записи',
				];
			}
		}
	}
}
else
{
	$json = [
		'error'   => 1, 
		'comment' => '404 Bad Request'
	];
}
echo json_encode($json, JSON_UNESCAPED_UNICODE);
