<?php
require_once($_SERVER['DOCUMENT_ROOT'].'/system/App.php');
	
if ($sys->isAjax())
{
	$files = $_FILES;
	$maxSize = 3;
	$arrTypes = [
		'gif',
		'jpg',
		'png',
		'jpeg', 
		'bmp',
	];
	$uploadDir = '/uploads/avatar/'; 
	
	
	if (empty($files) && count($files) < 1)
	{
		$json = [
			'error' => 1,
			'comment' => 'Изображение не выбрано',
		];
	}
	else
	{
		foreach($files as $key => $value)
		{
			$name = $value['name'];
			$uploadType = substr($name, strrpos($name, ".") + 1);
			$newName = $_SERVER['HTTP_HOST'].'_avatar-'.$core->hash(5).'.'.$uploadType;
			
			if (!file_exists($value['tmp_name']))
			{
				$json = [
					'error'   => 1,
					'comment' => 'Изображение не выбрано',
				];
			}
			elseif ($value['size'] > (1048576 * $maxSize))
			{
				$json = [
					'error'   => 1,
					'comment' => 'Вес изображения не должен превышать '.$maxSize.' мб',
				];
			}
			elseif (!in_array($uploadType, $arrTypes))
	        {
				$json = [
					'error' => 1, 
					'comment' => 'Файл данного формата выгружать запрещено',
				];
			}
			else
			{
				if (move_uploaded_file($value['tmp_name'], ROOT.$uploadDir.$newName))
				{
					Base::update('user', $me['id'], [
						'avatar' => $uploadDir.$newName,
					]);
					
					$json = [
						'success' => 1, 
						'comment' => 'Аватар успешно загружен',
						'avatar' => HOME.$uploadDir.$newName,
					];
				}
				else
				{
					$json = [
						'error' => 1, 
						'comment' => 'Ошибка загрузки',
					];
				}
			}
		}
	}
}
else
{
	$json = [
		'error' => 1, 
		'comment' => '404 Bad Request'
	];
}
echo json_encode($json, JSON_UNESCAPED_UNICODE);
