<?php
require_once($_SERVER['DOCUMENT_ROOT'].'/system/App.php');

if(isset($_POST) && $_SERVER['REQUEST_METHOD'] == 'POST')
{
	$login = isset($_POST['login']) && !empty($_POST['login']) ? $sys->protect($_POST['login']) : null;
	$name = isset($_POST['name']) && !empty($_POST['name']) ? $sys->protect($_POST['name']) : null;
	$gender =  isset($_POST['gender']) && !empty($_POST['gender']) ? intval($_POST['gender']) : null;
	$password = isset($_POST['password']) && !empty($_POST['password']) ? $sys->protect($_POST['password']) : null;
	$last_name = isset($_POST['last_name']) && !empty($_POST['last_name']) ? $sys->protect($_POST['last_name']) : null;
	
	if(!empty($me))
	{
		$json = ['error' => 1, 'comment' => 'Вы авторизированы на сайте'];
	}
	else if(empty($login))
	{
		$json = ['error' => 1, 'comment' => 'Введите логин'];
	}
	else if(empty($password))
	{
		$json = ['error' => 1, 'comment' => 'Введите пароль'];
	}
	else if(empty($name))
	{
		$json = ['error' => 1, 'comment' => 'Введите имя'];
	}
	else if(empty($last_name))
	{
		$json = ['error' => 1, 'comment' => 'Введите фамилию'];
	}
	else if(!preg_match('|^[a-zA-Z0-9_-]{4,20}+$|i', $login))
	{
		$json = ['error' => 1, 'comment' => 'Не корректный логин'];
	}
	else if(!preg_match('|^[a-zA-Z0-9_-]{6,30}+$|i', $password))
	{
		$json = ['error' => 1, 'comment' => 'Не корректный пароль'];
	}
	else
	{
		$checkLogin = Base::get('user', ['login' => $login]);
		
		if(!empty($checkLogin))
		{
			$json = ['error' => 1, 'comment' => 'Данный логин уже занят'];
		}
		else
		{
			setcookie('login', $login, time()+60*60*24*30, '/');
			setcookie('password', $password, time()+60*60*24*30, '/');
			$insert_id = Base::add('user', [
				'name' => $name,
				'login' => $login,
				'date_reg/int' => TIME,
				'gender/int' => $gender,
				'password' => $password,
				'last_name' => $last_name,
			]);
			
			if($insert_id == 1)
			{
				Base::update('user', $insert_id, ['access' => 3]);
			}
			
			$json = ['success' => 1, 'comment' => 'Регистрация прошла успешно!<br> Ваши данные для входа на сайт:<br> Логин: '.$login.'<br> Пароль: '.$password];
		}
	}
}
else
{
	$json = ['error' => 1, 'comment' => 'Пустое значение'];
}

echo json_encode($json, JSON_UNESCAPED_UNICODE);
?>
	