<?php
require_once('../system/App.php');

$dir = '../uploads/avatar/';
$max = 5;
$type = array('jpg','gif','png','jpeg');

foreach($_FILES as $key => $value)
{
	$uptype = substr($value['name'], strrpos($value['name'], ".") + 1);
	$new_name = $_SERVER['HTTP_HOST'].'-avatar_'.$core->hash(15).'.'.$uptype;
	
	if(!file_exists($value['tmp_name']))
	{
		$json = array('error' => '1', 'comment' => 'Выберите фото');
	}
	elseif($value['size'] > (1048576 * $max))
	{
		$json = array('error' => '1', 'comment' => 'Вес фото должен быть не более '.$max.' мб');
	}
	elseif(!in_array($uptype, $type))
	{
		$json = array('error' => '1', 'comment' => 'Файл данного формата выгружать запрещено');
	}
	else
	{
		if(move_uploaded_file($value['tmp_name'], $dir.$new_name))
		{
			if(!empty($me['avatar']) && $me['avatar'] != 'design/img/ava.jpg' && is_file($dir.$me['avatar']))
			{
				unlink($dir.$me['avatar']);
			}
			
			if(Base::add('photos', ['name' => $new_name, 'user_id' => $me['id']]) && Base::update('user', $me['id'], ['avatar' => '/uploads/avatar/'.$new_name]))
			{
				$json = array('success' => '1', 'comment' => 'Изображение успешно загружено', 'avatar' => '/uploads/avatar/'.$new_name);
			}
			else
			{
				$json = array('error' => '1', 'comment' => 'Ошибка записи изображения в бд');
			}
		}
		else
		{
			$json = array('error' => '1', 'comment' => 'Ошибка загрузки');
		}
	}

}

echo json_encode($json, JSON_UNESCAPED_UNICODE);
?>