<?php
require_once('../system/App.php');

$dir = '../uploads/avatar/';
$max = 5;
$type = array('jpg','gif','png','jpeg');

foreach($_FILES as $key => $value)
{
	$uptype = substr($value['name'], strrpos($value['name'], ".") + 1);
	
	if(!file_exists($value['tmp_name']))
	{
		$json = array('error' => '1', 'comment' => 'Выберите фото');
	}
	elseif($value['size'] > (1048576 * $max))
	{
		$json = array('error' => '1', 'comment' => 'Вес фото должен быть не более '.$max.' мб');
	}
	elseif(!in_array($uptype, $type))
	{
		$json = array('error' => '1', 'comment' => 'Файл данного формата выгружать запрещено');
	}
	else
	{
		if(@move_uploaded_file($value['tmp_name'], $dir.$value['name']))
		{
			if($photoId = Base::add('photos', ['name' => $value['name'], 'user_id' => $me['id']]))
			{
				$json = array('success' => '1', 'comment' => 'Аватар успешно загружен', 'avatar' => $dir.$value['name'], 'photo_id' => $photoId);
			}
			else
			{
				$json = array('error' => '1', 'comment' => 'Ошибка загрузки');
			}
		}
		else
		{
			$json = array('error' => '1', 'comment' => 'Файл не был загружен на сервер');
		}
	}

}

echo json_encode($json, JSON_UNESCAPED_UNICODE);
?>