<?php
require_once $_SERVER['DOCUMENT_ROOT'].'/system/App.php';

$max = 5;
$type = ['jpg','gif','png','jpeg', 'bmp'];
$me['id'] = !empty($me) ? $me['id'] : 0;
$uploadDir = ROOT.'/uploads/tmp/'; 
$guestHash = isset($_COOKIE['guest_hash']) && empty($me['id']) ? htmlspecialchars($_COOKIE['guest_hash']) : null;

if(!is_dir( $uploadDir)) mkdir( $uploadDir, 0777 );

if(isset($_POST) && $_SERVER['REQUEST_METHOD'] == 'POST')
{
	$files = $_FILES;
    $formId = isset($_POST['form_id']) ? intval($_POST['form_id']) : null;
    $countFiles = count($files);
    
	if(empty($files) || $countFiles < 1)
	{
		$json = ['error' => '1', 'comment' => 'Изображения не выбраны'];
	}
	else if($countFiles > $settings->max_files_to_download && $me['vip'] != 1)
	{
		$json = ['error' => '1', 'comment' => 'Вы не можете загружать больше '.$settings->id.' изображений, у вас нет привелегии <a href="/pay/vip">VIP</a>'];
	}
	else
	{
		foreach($files as $value)
		{
			$name = $value['name'];
			$newName = $formId.'_'.preg_replace('/[^A-z0-9\.]+/u', '', $name);
	    	$uploadType = substr($name, strrpos($name, ".") + 1);
	    	
	    	if(!file_exists($value['tmp_name']))
	    	{
	    		$json = ['error' => '1', 'comment' => 'Выберите файл'];
	    	}
	    	elseif($value['size'] > (1048576 * $max))
	    	{
	    		$json = ['error' => '1', 'comment' => 'Вес файла должен быть не более '.$max.' мб'];
	    	}
	    	elseif(!in_array($uploadType, $type))
	    	{
	    		$json = ['error' => '1', 'comment' => 'Файл данного формата выгружать запрещено'];
	    	}
	    	else
	    	{
	            if(move_uploaded_file($value['tmp_name'], $uploadDir.$newName))
			    {
	    			if(Base::add('photos', ['name' => $newName, 'guest_hash' => $guestHash, 'user_id' => $me['id']]))
	    			{
	    				$json = ['success' => '1', 'comment' => 'Загрузка прошла успешно', 'count' => $countFiles];
	    			}
	    			else
	    			{
	    				$json = ['error' => '1', 'comment' => 'Ошибка записи изображения в бд'];
	    			}
			    }
			    else
	    		{
	    			$json = ['error' => '1', 'comment' => 'Ошибка загрузки изображения'];
	    		}
	    	}
	    }
    }
}
else
{
	$json = ['error' => '1', 'comment' => 'Пустое значение'];
}

echo json_encode($json, JSON_UNESCAPED_UNICODE);
?>