<?php
require_once $_SERVER['DOCUMENT_ROOT'].'/system/App.php';
$title = 'Добавить в друзья';
require_once ROOT.'/system/header.php';

$id = $_GET['id'] ?? null;

$getUserInfo = !empty($id) ? $user->infobyid($id, 'name, last_name') : false;

if ($friends->isFriends($me['id'], $id) || $friends->isSubscriber($me['id'], $id) || $friends->isSubscriber($id, $me['id']) || $me['id'] == $id) $core->redirect('/id'.$id);
?>
	
<div class="col-lg-4"></div>
<div class="col-sm-8 col-md-6 col-lg-4">
	
	<?php if ($getUserInfo): ?>
		<nav aria-label="breadcrumb">
			<ol class="breadcrumb">
				<div class="b-item">
					<li class="breadcrumb-item">
						<a href="/id<?=$id?>"><?=$getUserInfo['name']?> <?=$getUserInfo['last_name']?></a>
					</li>
					<li class="breadcrumb-item active" aria-current="page"><?=$title?></li>
				</div>
			</ol>
		</nav>
		
		<script>
			$(document).ready(function () {
				var alerts = $('#alerts');
				var form = $('#form-add');
				var user_id = '<?=$id?>';
				
				form.on('submit', function(e) {
					e.preventDefault();
					
					var formData = {
						message: $('#message').val(),
						id: user_id,
					} 
					
					$.ajax({
						url: '/AJAX/friends/addToFriend.php',
						type: 'POST',
						data: formData,
						dataType: 'json',
						beforeSend: function() {
							$('#okButton').prop('disabled', true);
						},
						success: function(json) {
							
							if (json['success'] == 1)
							{
								alerts.addClass('alert alert-success');
								alerts.html(json['comment']);
							}
							else
							{
								alerts.addClass('alert alert-danger');
								alerts.html(json['comment']);
							}
							
							setTimeout(function () {
								alerts.removeClass();
								alerts.html('');
							}, 2000);
						},
						error: function(xhr, ajaxOptions, thrownError) {
							alert('Ошибка: ' + thrownError + "\r\nСтатус: " + xhr.statusText + "\r\nОтвет: " + xhr.responseText);
						},
						complete: function() {
							$('#okButton').prop('disabled', false);
						}
					});
				});
			});
		</script>
	
		<div id="alerts"></div>
	
		<div class="card">
			<div class="card-body">
				<form action="/AJAX/friends/addFriend.php" method="POST" id="form-add">
					<div class="form-row">
						<div class="col-12">
							<div class="form-group">
								<label for="message" class="text-muted">Ваше сообщение пользователю</label>
								<textarea class="form-control" name="message" id="message" rows="3"></textarea>
							</div>
						</div>
						<div class="col-8">
							<button type="submit" class="btn btn-md btn-theme" style="border: 0!important;" name="smile" id="smilePanel">
								<i class="material-icons md-24">sentiment_satisfied</i>
							</button>
						</div>
						<div class="col-4">
							<button type="submit" class="btn btn-theme-link btn-md float-right" id="okButton"><i class="material-icons md-24">send</i></button>
						</div>
					</div> <!-- row -->
				</form>
			</div>
		</div>
	<?php else: ?>
		<?=$core->alert('Пользователь не найден', 'danger')?>
	<?php endif; ?>
</div>
<div class="col-lg-4"></div>
<?php
require_once ROOT.'/system/footer.php';
?>