<?php
require_once $_SERVER['DOCUMENT_ROOT'].'/system/App.php';
$title = 'Друзья';
require_once ROOT.'/system/header.php';
?>
<div class="col-lg-4"></div>
<div class="col-sm-8 col-md-6 col-lg-4">
	
	<nav aria-label="breadcrumb">
		<ol class="breadcrumb navig">
			<div class="b-item">
				<li class="breadcrumb-item">
					<a href="/">На главную</a>
				</li>
				<li class="breadcrumb-item active" aria-current="page"><?=$title?></li>
			</div>
		</ol>
	</nav>
	
	<ul class="nav nav-pills nav-fill nav-pills-theme" id="myTab" role="tablist">
		<li class="nav-item "> <a class="nav-link left-radius color-theme active" id="friends-tab" data-toggle="tab" href="#friends" role="tab" aria-controls="friends" aria-selected="true">Друзья <span id="count-friends" class="badge badge-info float-right mt-1"></span></a> </li> 
		<li class="nav-item "> <a class="nav-link color-theme" id="online-tab" data-toggle="tab" href="#online" role="tab" aria-controls="online" aria-selected="false">В сети <span id="count-online" class="badge badge-info float-right mt-1"></span></a> </li> 
		<li class="nav-item "> <a class="nav-link right-radius color-theme" id="sub-tab" data-toggle="tab" href="#sub" role="tab" aria-controls="sub" aria-selected="false">Заявки <span id="count-subs" class="badge badge-info float-right mt-1"></span></a> </li> 
	</ul>
	
	<script>
		$(document).ready(function () {
			var home = window.location.protocol + '//' + window.location.hostname;
			var alerts = $('#alerts');
			var countSubs = $('#count-subs');
			var countOnline = $('#count-online');
			var countFriends = $('#count-friends');
			
			countFriends.addClass('bg-dark');
			getFriends();
			
			$('a[data-toggle="tab"]').on('show.bs.tab', function (e) {
				var controls = $(this).attr('aria-controls');
				
				if (controls == 'friends')
				{
					countFriends.addClass('bg-dark');
					
					getFriends();
				}
				else if(controls == 'online')
				{
					countOnline.addClass('bg-dark');
					
					getFriendsOnline();
				}
				else if(controls == 'sub')
				{
					countSubs.addClass('bg-dark');
					
					getSubscribers();
				}
				
			}).on('hidden.bs.tab', function(e) {
				var controls = $(e.target).attr('aria-controls');
				
				$(this).find('span').removeClass('bg-dark');
				$('#' + controls).tab('dispose');
			});
			
			function getFriends() {
				var friends = $('#friends');
				var alerts = $('#alerts');
				
	            $.ajax({
	            url: '/AJAX/friends/getFriends.php',
	            type: 'POST',
	            data: {offset: 0, limit: 10},
	            dataType: 'json',
				beforeSend: function() {
					// $('#loader').show();
				},
	            success: function(json) {
					
					if (json['success'] == 1)
					{
						countFriends.text(json['response'].length);
						
						friends.html('<div class="card"><ul class="list-group list-group-flush" id="response-friends"></ul></div>');
						
						json['response'].forEach(function(friend) {
							var avatar = '<div class="media-avatar mr-2" style="background-image: url(' + home + friend['friend_avatar'] + ');" alt=""></div>';
							var name = '<div class="media-body"><a href="/id' + friend['friend_id'] + '" class="d-block text-light">' + friend['name'] + ' ' + friend['last_name'] + ' <span class="badge badge-theme badge-pill float-right mt-1">' + friend['date_last'] + '</span></a></div>';
							var buttons = '<div class="row text-center mt-3"><span class="col"><a href="/mail/new/id' + friend['friend_id'] + '" class="btn btn-theme-active btn-sm btn-block" data-id="' + friend['friend_id'] + '">Написать</a></span><span class="col"><a href="#delete" class="btn btn-theme-link btn-sm btn-block remove-friend" data-id="' + friend['friend_id'] + '">Удалить</a></span></div>';
							
							$('#response-friends').append('<li class="list-group-item" id="friend-' + friend['friend_id'] + '"><div class="media">' + avatar + name + '</div>' + buttons + '</li>');
						});
						
					}
					else
					{
						countFriends.text('');
	                	friends.html('<div class="alert alert-danger">' + json['comment'] + '</div>');
	                }
	            },
	            error: function(xhr, ajaxOptions, thrownError) {
	            	alert(thrownError + "\r\n" + xhr.statusText + "\r\n " + xhr.responseText);
	            },
	            complete: function() {
					// $('#loader').hide();
				}
	            });
			}
			
			function getFriendsOnline() {
				var online = $('#online');
				var alerts = $('#alerts');
				
	            $.ajax({
	            url: '/AJAX/friends/getFriendsOnline.php',
	            type: 'POST',
	            data: {offset: 0, limit: 10},
	            dataType: 'json',
				beforeSend: function() {
					// $('#loader').show();
				},
	            success: function(json) {
					// online.append(json);
					
					if (json['success'] == 1)
					{
						countOnline.text(json['response'].length);
						
						online.html('<div class="card"><ul class="list-group list-group-flush" id="response-online"></ul></div>');
						
						json['response'].forEach(function(friend) {
							var avatar = '<div class="media-avatar mr-2" style="background-image: url(' + home + friend['friend_avatar'] + ');" alt=""></div>';
							var name = '<div class="media-body"><a href="/id' + friend['friend_id'] + '" class="d-block text-light">' + friend['name'] + ' ' + friend['last_name'] + ' <span class="badge badge-theme badge-pill float-right mt-1">' + friend['date_last'] + '</span></a></div>';
							
							$('#response-online').append('<li class="list-group-item"><div class="media">' + avatar + name + '</div></li>');
						});
					}
					else if (json['error'] == 1)
					{
						countOnline.text('');
						
	                	online.html('<div class="alert alert-danger">' + json['comment'] + '</div>');
	                }
					
	            },
	            error: function(xhr, ajaxOptions, thrownError) {
	            	alert(thrownError + "\r\n" + xhr.statusText + "\r\n " + xhr.responseText);
	            },
	            complete: function() {
					// $('#loader').hide();
				}
	            });
			}
			
			function getSubscribers() {
				var sub = $('#sub');
				var alerts = $('#alerts');
				
	            $.ajax({
	            url: '/AJAX/friends/getSubscribers.php',
	            type: 'POST',
	            data: {offset: 0, limit: 10},
	            dataType: 'json',
				beforeSend: function() {
					// $('#loader').show();
				},
	            success: function(json) {
					// sub.append(json);
					
					if (json['success'] == 1)
					{
						countSubs.text(json['response'].length);
						
						sub.html('<div class="card"><ul class="list-group list-group-flush" id="response-sub"></ul></div>');
						
						json['response'].forEach(function(friend) {
							var avatar = '<div class="media-avatar mr-2" style="background-image: url(' + home + friend['friend_avatar'] + ');" alt=""></div>';
							var name = '<div class="media-body"><a href="/id' + friend['friend_id'] + '" class="d-block text-light">' + friend['name'] + ' ' + friend['last_name'] + ' <span class="badge badge-theme badge-pill float-right mt-1">' + friend['date_last'] + '</span></a><small >' + friend['message'] + '</small></div>';
							var buttons = '<div class="row text-center mt-3"><span class="col"><a href="#addFriend" class="btn btn-theme-active btn-sm btn-block accept-application" data-id="' + friend['friend_id'] + '">Принять</a></span><span class="col"><a href="#add" class="btn btn-link text-light btn-sm btn-block reject-application" data-id="' + friend['friend_id'] + '">Отклонить</a></span></div>';
							
							$('#response-sub').append('<li class="list-group-item" id="sub-' + friend['friend_id'] + '"><div class="media">' + avatar + name + '</div>' + buttons + '</li>');
						});
					}
					else
					{
						countSubs.text('');
	                	sub.html('<div class="alert alert-danger">' + json['comment'] + '</div>');
	                }
					
	            },
	            error: function(xhr, ajaxOptions, thrownError) {
	            	alert(thrownError + "\r\n" + xhr.statusText + "\r\n " + xhr.responseText);
	            },
	            complete: function() {
					// $('#loader').hide();
				}
	            });
			}
			
			$(this).on('click', '.accept-application', function(e){
				e.preventDefault();
				var data = $(this).attr('data-id');
				
				$.ajax({
					url: '/AJAX/friends/acceptApplication.php',
					type: 'POST',
					data: {id: data},
					dataType: 'json',
					success: function(json) {
						
						if (json['success'] == 1)
						{
							alerts.addClass("alert alert-success");
							alerts.html(json['comment']);
						}
						else
						{
							alerts.addClass("alert alert-danger");
							alerts.html(json['comment']);
						}
						
						setTimeout(function() {
							alerts.removeClass();
							alerts.html('');
							
							$('#sub-' + data).remove();
							getSubscribers();
						}, 1000);
					},
					error: function(xhr, ajaxOptions, thrownError) {
						alert(thrownError + "\r\n" + xhr.statusText + "\r\n " + xhr.responseText);
					}
				});
			}).on('click', '.reject-application', function(e){
				e.preventDefault();
				var data = $(this).attr('data-id');
				
				$.ajax({
					url: '/AJAX/friends/rejectApplication.php',
					type: 'POST',
					data: {id: data},
					dataType: 'json',
					success: function(json) {
						
						if (json['success'] == 1)
						{
							alerts.addClass("alert alert-success");
							alerts.html(json['comment']);
						}
						else
						{
							alerts.addClass("alert alert-danger");
							alerts.html(json['comment']);
						}
						
						setTimeout(function() {
							alerts.removeClass();
							alerts.html('');
							
							$('#sub-' + data).remove();
							getSubscribers();
						}, 1000);
					},
					error: function(xhr, ajaxOptions, thrownError) {
						alert(thrownError + "\r\n" + xhr.statusText + "\r\n " + xhr.responseText);
					}
				});
			}).on('click', '.remove-friend', function(e){
				e.preventDefault();
				var data = $(this).attr('data-id');
				
				$.ajax({
					url: '/AJAX/friends/removeFriend.php',
					type: 'POST',
					data: {id: data},
					dataType: 'json',
					success: function(json) {
						
						if (json['success'] == 1)
						{
							alerts.addClass("alert alert-success");
							alerts.html(json['comment']);
							
						}
						else
						{
							alerts.addClass("alert alert-danger");
							alerts.html(json['comment']);
						}
						
						setTimeout(function() {
							alerts.removeClass();
							alerts.html('');
							//$('#friend-' + data).remove();
							
							getFriends();
						}, 1000);
					},
					error: function(xhr, ajaxOptions, thrownError) {
						alert(thrownError + "\r\n" + xhr.statusText + "\r\n " + xhr.responseText);
					}
				});
			});
			
		});
	</script>
	
	<div id="alerts"></div>
	
	<div class="tab-content" id="myTabContent"> 
		<div class="tab-pane fade show active" id="friends" role="tabpanel" aria-labelledby="friends-tab"></div>
		<div class="tab-pane fade" id="online" role="tabpanel" aria-labelledby="online-tab"></div>
		<div class="tab-pane fade" id="sub" role="tabpanel" aria-labelledby="sub-tab"></div>
	</div>

</div>
<div class="col-lg-4"></div>
<?php
require_once ROOT.'/system/footer.php';
?>