<?php 
require_once $_SERVER['DOCUMENT_ROOT'].'/system/App.php';
$title = 'Восстановление пароля';
require_once ROOT.'/system/header.php';

$user->access('guest');
?>
	
<div class="col-sm"></div>
<div class="col-sm-10 col-md-8 col-lg-4">
	<nav aria-label="breadcrumb">
	<ol class="breadcrumb">
		<div class="b-item">
			<li class="breadcrumb-item">
				<a href="/">На главную</a>
			</li>
			<li class="breadcrumb-item active" aria-current="page"><?=$title?></li>
		</div>
	</ol>
	</nav>
	
	<div id="alerts"></div>
	
	<script>
	$(document).ready(function() {
		
		var alerts = $('#alerts');
		var stageOne = $('#stageOne');
		var stageTwo = $('#stageTwo');
		var forgotFormOne = $('#forgotFormOne');
		var forgotFormTwo = $('#forgotFormTwo');
		
		$(forgotFormOne).on('submit', function(e) {
			e.preventDefault();
			
			var formData = $(this).serialize();
			
			$.ajax({
				url: '/AJAX/login/forgot.php?stage=1',
				type: 'POST',
				data: formData,
				dataType: 'json',
				success: function(json) {
					
					if (json['error'] == 1) 
					{
						$(alerts).addClass('alert alert-danger');
						$(alerts).html(json['comment']);
					}
					else if (json['success'] == 1) 
					{
						$(alerts).addClass('alert alert-success');
						$(alerts).html(json['comment']);
						
						$('#inputHash').val(json['hash']);
						$(stageOne).hide();
						$(stageTwo).show();
					}
					
					setTimeout(function() {
						$(alerts).removeClass();
						$(alerts).html('');
					}, 3000);
				},
				error: function(xhr, ajaxOptions, thrownError) {
					alert("Ошибка восстановления пароля \r\nФайл: /AJAX/login/forgot.php \r\nОшибка: " + thrownError + "\r\nСтатус: " + xhr.statusText + "\r\n Ответ: " + xhr.responseText);
				}
			});
			
		});
		
		$(forgotFormTwo).on('submit', function(e) {
			e.preventDefault();
			
			var formData = $(this).serialize();
			
			$.ajax({
				url: '/AJAX/login/forgot.php?stage=2',
				type: 'POST',
				data: formData,
				dataType: 'json',
				success: function(json) {
					
					if (json['error'] == 1) 
					{
						$(alerts).addClass('alert alert-danger');
						$(alerts).html(json['comment']);
					}
					else if (json['success'] == 1) 
					{
						$(alerts).addClass('alert alert-success');
						$(alerts).html(json['comment']);
					}
					
					setTimeout(function() {
						$(alerts).removeClass();
						$(alerts).html('');
					}, 3000);
				},
				error: function(xhr, ajaxOptions, thrownError) {
					alert("Ошибка восстановления пароля \r\nФайл: /AJAX/login/forgot.php \r\nОшибка: " + thrownError + "\r\nСтатус: " + xhr.statusText + "\r\n Ответ: " + xhr.responseText);
				}
			});
			
		});
	});
	</script>
	
	<div class="card">
		<div class="card-body" id="stageOne">
			<form id="forgotFormOne">
				<div class="form-group">
					<label class="form-check-label text-secondary" for="inputLogin">Логин или телефон</label>
					<input type="text" class="form-control" id="inputLogin" name="login">
					<small id="loginHelp" class="form-text text-muted">На ваш телефон будет отправлено смс с пин-кодом</small>
				</div>
				<button type="submit" class="btn btn-md btn-theme-active " id="okButton">Отправить</button>
			</form>
		</div>
		<div class="card-body" id="stageTwo" style="display:none;">
			<form id="forgotFormTwo">
				<div class="form-group">
					<label class="form-check-label text-secondary" for="inputPassword">Новый пароль</label>
					<input type="text" class="form-control" id="inputPassword" name="password">
				</div>
				<div class="form-group">
					<label class="form-check-label text-secondary" for="inputPincode">Пин-код</label>
					<input type="text" class="form-control" id="inputPincode" name="pincode">
				</div>
				<input type="hidden" id="inputHash" name="hash">
					
				<button type="submit" class="btn btn-md btn-theme-active " id="remindButton">Сменить</button>
			</form>
		</div>
	</div>
</div>
<div class="col-sm"></div>

<?php
require ROOT.'/system/footer.php';
?>