<?php 
require_once $_SERVER['DOCUMENT_ROOT'].'/system/App.php';
$title = 'Регистрация';
require_once ROOT.'/system/header.php';
$user->access('guest');

?>
<div class="col-sm"></div>

<div class="col-sm-10 col-md-8 col-lg-4">
	<div id="alerts"></div>
	<script type="text/javascript">
	$(document).ready(function () {
		
		$('#okButton').on('click', function(e) {
			e.preventDefault();
			var formData = $('#regForm').serialize();
			var alerts = $('#alerts');
			
			$.ajax({
			url: '/AJAX/registrationUser.php',
			type: 'POST',
			data: formData,
			dataType: 'json',
			success: function(json) {
				
				if(json['error'] == 1) {
					$(alerts).html('<div class="alert alert-danger">'+json['comment']+'</div>');
				} else if(json['success'] == 1) {
					$(alerts).html('<div class="alert alert-success">'+json['comment']+'</div>');
				}
				setTimeout(function () {
					$(alerts).html('');
					if(json['success'] == 1) {
						location.href = '<?=HOME.'/main'?>';
					}
				}, 6000);
			},
			error: function(xhr, ajaxOptions, thrownError) {
				alert(thrownError + "\r\n" + xhr.statusText + "\r\n " + xhr.responseText);
			}
			});
		});
	});
	</script>
	<div class="card">
		<div class="card-body">
			<p class="text-center">
				Перед регистрацией не забудьте прочитать <a href="/rules" class="card-link text-bold">правила</a>.
			</p>

			<form action="/AJAX/registrationUser.php" method="POST" id="regForm">
				<div class="form-group">
					<label class="form-check-label text-secondary" for="inputName">Имя</label>
					<input type="name" class="form-control" id="inputName" name="name" >
				</div>
				<div class="form-group">
					<label class="form-check-label text-secondary" for="inputLastName">Фамилия</label>
					<input type="name" class="form-control" id="inputLastName" name="last_name" >
				</div>
				<div class="form-group">
				    <label class="form-check-label text-secondary" for="inputLogin">Логин</label>
					<input type="login" class="form-control" id="inputLogin" name="login" >
				</div>
				<div class="form-group">
					<label class="form-check-label text-secondary" for="inputPassword">Пароль</label>
					<input type="password" class="form-control" id="inputPassword" name="password" >
				</div>
				<div class="form-group">
					<label class="form-check-label text-secondary" for="inputGender">Пол</label>
					<select class="form-control" name="gender" id="inputGender">
						<option value="1">Мужской</option>
						<option value="0">Женский</option>
					</select>
				</div>
				<div class="text-center">
					<button type="submit" class="btn btn-md btn-theme-active " id="okButton">Регистрация</button>
				</div>
			</form>
		</div>
		<div class="card-footer border-0">
			<a href="/authorization" class="btn btn-md btn-theme-link btn-block" name="ok">Уже есть профиль?</a>
		</div>
	</div>
</div>

<div class="col-sm"></div>
<?php
require ROOT.'/system/footer.php';
?>