<?php 
require_once $_SERVER['DOCUMENT_ROOT'].'/system/App.php';
$header = 'Диалоги';
require_once ROOT.'/system/header.php';

$user->access();
?>
<div class="col">
</div>

<div class="col-sm-8 col-md-6 col-lg-4 col-xl-4">
<nav aria-label="breadcrumb">
	<ol class="breadcrumb">
		<div class="b-item">
			<li class="breadcrumb-item">
				<a href="/mail">Диалоги</a>
			</li>
			<li class="breadcrumb-item active" aria-current="page">Создать беседу</li>
		</div>
	</ol>
</nav>


	<script type="text/javascript">
	$(document).ready(function () {
	
		var progressBar = $('#progressbar'); // Прогрессбар
		// Удаление аватара
		$('#removeAvatar').on('click', function(e) {
			e.preventDefault();
			
			$.ajax({
			url: '/AJAX/removeAvatar.php',
			type: 'GET',
			data: $('#removeAvatar'), // можно строкой, а можно, например, так: $('input[type="text"], input[type="radio"]:checked, input[type="checkbox"]:checked, select, textarea')
			dataType: 'json',
			success: function(json) {
				if(json['error'] == 1)
				{
					alert(json['comment']);
					location.href = 'http://<?=$_SERVER['HTTP_HOST'].htmlspecialchars($_SERVER['REQUEST_URI'])?>';
				}
				else if(json['success'] == 1)
				{
					alert(json['comment']);
					location.href = 'http://<?=$_SERVER['HTTP_HOST'].htmlspecialchars($_SERVER['REQUEST_URI'])?>';
				}
			},
			error: function(xhr, ajaxOptions, thrownError) {
				alert('Ошибка: ' + thrownError + "\r\n" + xhr.statusText + "\r\n " + xhr.responseText);
				location.href = 'http://<?=$_SERVER['HTTP_HOST'].htmlspecialchars($_SERVER['REQUEST_URI'])?>';
			}
			});
			
		});
		
		// Загрузка аватара
		$('#avatar').on('change', function(e) {
			e.preventDefault();
			progressBar.show();
			var $that = $('#uploadChatAvatar'), formData = new FormData($that.get(0));
			
			$.ajax({
			url: $that.attr('action'),
			type: $that.attr('method'),
			contentType: false,
			processData: false,
			data: formData,
			dataType: 'json',
			xhr: function() {
				var xhr = $.ajaxSettings.xhr();
				xhr.upload.addEventListener('progress', function(evt) {
				
					if(evt.lengthComputable) {
						var percentComplete = Math.ceil(evt.loaded / evt.total * 100);
						progressBar.val(percentComplete).text('Загружено ' + percentComplete + '%');
					}
				}, false);
				
				return xhr;
			},
			success: function(json)	{
				progressBar.hide();
				$('#alerts').show();
				
				if(json['error'] == 1) {
					$('#alerts').html('<div class="alert alert-danger">'+json['comment']+'</div>');
					location.href = 'http://<?=$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI']?>';
				} else if(json['success'] == 1) {
					$('#alerts').html('<div class="alert alert-success">'+json['comment']+'</div>');
					$('#previewAvatar').html('<span class="upload-avatar" style="background-image: url(' + json['avatar'] + ');"></span>');
					$('#avatarUrl').val(json['avatar']);
				}
				
				setTimeout(function () {
					$('#alerts').hide();
				}, 1500);
			
			},
			error: function(xhr, ajaxOptions, thrownError) {
			alert('Ошибка загрузки: ' + thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
			location.href = 'http://<?=$_SERVER['HTTP_HOST'].htmlspecialchars($_SERVER['REQUEST_URI'])?>';
			}
			});
			
		});
		/*
		$('#searchName').on('input', function(e) {
			e.preventDefault();
			var $that = $('#searchFriends');
			
			$.ajax({
			url: $that.attr('action'),
			type: $that.attr('method'),
			contentType: false,
			processData: false,
			data: $(this),
			dataType: 'json',
			success: function(json)	{
				$('#alerts').show();
			
				if(json['error'] == 1) {
					$('#alerts').html('<div class="alert alert-danger">'+json['comment']+'</div>');
				} else if(json['success'] == 1) {
					$('#searchResult').html(json['result']);
				}
			
				setTimeout(function () {
					$('#alerts').hide();
				}, 1500);
			
			},
			error: function(xhr, ajaxOptions, thrownError) {
				alert('Ошибка: ' + thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
				//location.href = 'http://<?=$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI']?>';
			}
			});
		});
		*/
		
		$('#searchForm').on('submit', function(e) {
		e.preventDefault();
		var formData = $('#searchForm').serialize();
		$('#searchResult').html('<div class="card-body text-center text-muted">Загрузка...</div>');
		//$('#searchInput').val('');
		$.ajax({
		url: '/AJAX/searchFriends.php',
		type: 'GET',
		data: formData, // можно строкой, а можно, например, так: $('input[type="text"], input[type="radio"]:checked, input[type="checkbox"]:checked, select, textarea')
		dataType: 'json',
		success: function(json) {
		$('#alerts').show();
		
		if(json['error'] == 1) {
			$('#alerts').html('<div class="alert alert-danger">'+json['comment']+'</div>');
			$('#searchResult').html('');
		} else if(json['success'] == 1) {
			$('#searchResult').html('');
			json['result'].forEach(function(el) {
				$('#searchResult').append('<li class="list-group-item text-muted" id="list-users">' + el['name'] + ' ' + el['last_name'] + ' <small class="ml-1 text-danger">@' + el['login'] + '</small> <input type="checkbox" class="checkbox-input" name="user_id[]" value="' + el['id'] + '"></li>');
			});
		}
		
		setTimeout(function () {
			$('#alerts').hide();
		}, 2000);
		},
		error: function(xhr, ajaxOptions, thrownError) {
			alert(thrownError + "\r\n" + xhr.statusText + "\r\n " + xhr.responseText);
			$('#searchResult').html('');
		}
		});
		
		});
		
		
		$('#newChat').on('submit', function(e) {
		e.preventDefault();
		var formData = $('#newChat').serialize();
		
		$.ajax({
		url: '/AJAX/newMailChat.php',
		type: 'GET',
		data: formData, // можно строкой, а можно, например, так: $('input[type="text"], input[type="radio"]:checked, input[type="checkbox"]:checked, select, textarea')
		dataType: 'json',
		success: function(json) {
		$('#alerts').show();
		
		if(json['error'] == 1) {
			$('#alerts').html('<div class="alert alert-danger">'+json['comment']+'</div>');
		} else if(json['success'] == 1) {
			$('#alerts').html('<div class="alert alert-danger">'+json['comment']+'</div>');
			location.href = json['url'];
		}
		
		setTimeout(function () {
			$('#alerts').hide();
		}, 2000);
		},
		error: function(xhr, ajaxOptions, thrownError) {
			alert(thrownError + "\r\n" + xhr.statusText + "\r\n " + xhr.responseText);
		}
		});
		
		});
		
		$(document).on('change', '.checkbox-input', function() {
			if( $(this).prop('checked') )
			{
				$(this).parent('#list-users').addClass('checked');
			}
			else
			{
				$(this).parent('#list-users').removeClass('checked');
			}
		});
		
	});
	
	
	</script>
	
	
	<style type="text/css">
	#list-users {
	position: relative!important;
	overflow: hidden!important;
	}
	
	.checkbox-input {
	position: absolute;
	top: 0;
	left: 0;
	width: 100%;
	height: 100%;
	opacity: 0;
	}
	
	.checked {
	color: #777!important;
	background-color: #fefefe!important;
	border-right: 2px solid teal!important;
	}
	</style>

<div class="card">
<div class="card-header text-center">
	<div class="form_upload w-100 text-center">
		<form action="/AJAX/uploadChatAvatar.php" method="POST" id="uploadChatAvatar">
			<input type="file" name="avatar" style="z-index: 1000;" id="avatar">
			<span id="previewAvatar">
			<span class="upload-avatar" style="background-image: url(<?=$me['avatar']?>);">
				<div class="text-center text-light w-100 font-weight-bold"style="padding-top: 88px; height: 100%; border-radius: 100%; position: relative; top: 0; left: 0; background-color: rgba(0,0,0,0.4);">Выберите фото</div>
			</span>
			</span>
		</form>
	</div>
	<progress id="progressbar" value="0" max="100" style="display: none;"></progress>
	<div id="alerts" class="fixed-top p-1" style="top: 60px;"></div>
</div>
<div class="pl-2 mb-1">
	<form action="/AJAX/searchFriends.php" method="GET" id="searchForm">
		<div class="form-row">
			<div class="col-10 pt-2">
				<input type="text" class="form-control border-0 input-sm" id="searchInput" name="name" placeholder="Введите имя собеседника">
			</div>
			<div class="col-2">
				<button type="submit" class="btn btn-theme-link btn-sm" style="padding-top: 6px;" name="ok" id="searchButton"><i class="material-icons md-30">search</i></button>
			</div>
		</div>
	</form>
</div>
	
<form action="/AJAX/newMailChat.php" method="POST" id="newChat">
	<input type="hidden" name="chat_avatar" id="avatarUrl" value="<?=$me['avatar']?>">
	<ul class="list-group list-group-flush" style="" id="searchResult"></ul>
	
	<div class="send-form text-right">
		<div class="form-row">
			<div class="col-10 pt-2">
				<input type="text" class="form-control border-0 input-sm" id="chatName" name="chat_name" placeholder="Введите название беседы">
			</div>
			<div class="col-2">
				<button type="submit" class="btn btn-theme-link btn-sm" style="padding-top: 1px;" name="new_chat" id="createChat"><i class="material-icons md-36">add</i></button>
			</div>
		</div>
	</div>
</form>
</div>

</div>
<div class="col">
</div>
<?php
require ROOT.'/system/footer.php';
?>