<?php 
require_once $_SERVER['DOCUMENT_ROOT'].'/system/App.php';

if(!empty($id))
{
	$profile = $user->infoByID($id, 'login, name, last_name');
	if(empty($profile))
	{
		$core->redirect('/');
	}
}

$title = $profile['login'].'';
require_once ROOT.'/system/header.php';
$user->access();
?>
<div class="col"></div>

<div class="col-sm-4">

<nav aria-label="breadcrumb">
	<ol class="breadcrumb">
		<div class="b-item">
			<li class="breadcrumb-item">
				<a href="/id<?=$id?>"><?=$profile['login']?></a>
			</li>
			<li class="breadcrumb-item active" aria-current="page">Написать</li>
		</div>
	</ol>
</nav>

<script type="text/javascript">
$(document).ready(function () {
	
	$('#form').submit(function(e) {
		e.preventDefault();
		var formData = $('#form').serialize();
		
		$.ajax({
		url: '/AJAX/newDialog.php',
		type: 'POST',
		data: formData, // можно строкой, а можно, например, так: $('input[type="text"], input[type="radio"]:checked, input[type="checkbox"]:checked, select, textarea')
		dataType: 'json',
		success: function(json) {
			$('#alerts').show();
			
			if(json['error'] == 1) {
				$('#alerts').html('<div class="alert alert-danger">'+json['comment']+'</div>');
			} else if(json['success'] == 1) {
				$('#alerts').html('<div class="alert alert-success">'+json['comment']+'</div>');
				location.href = json['redirect'];
			}
			setTimeout(function () {
				$('#alerts').html('');
			}, 2000);
		},
		error: function(xhr, ajaxOptions, thrownError) {
			alert(thrownError + "\r\n" + xhr.statusText + "\r\n " + xhr.responseText);
		}
		});
		
	});
});
</script>

<div id="alerts"></div>

<div class="card">
<div class="card-body">
<form action="/AJAX/newDialog.php" method="GET" id="form">
<div class="form-row">
<div class="col-12">
<div class="form-group">
<label for="message" class="text-muted">Ваше сообщение пользователю</label>
<textarea class="form-control" name="message" id="message" rows="3"></textarea>
<input type="hidden" name="id" value="<?=$id?>" />
</div>
</div>

<div class="col-8">
<button type="submit" class="btn btn-md btn-theme" style="border: 0!important;" name="file" id="attachmentFile">
<i class="material-icons md-24">attach_file</i>
</button>
<button type="submit" class="btn btn-md btn-theme" style="border: 0!important;" name="photo" id="attachmentPhoto">
<i class="material-icons md-24">add_photo_alternate</i>
</button>
<button type="submit" class="btn btn-md btn-theme" style="border: 0!important;" name="smile" id="smilePanel">
<i class="material-icons md-24">sentiment_satisfied</i>
</button>
</div>
<div class="col-4">
<button type="submit" class="btn btn-theme-link btn-md float-right" name="ok" id="sendMessage"><i class="material-icons md-24">send</i></button>
</div>

</div> <!-- row -->
</form>

</div>
</div>

</div>
<div class="col"></div>
<?php
require ROOT.'/system/footer.php';
?>