<?php
require_once $_SERVER['DOCUMENT_ROOT'].'/system/App.php';
$title = 'Новая запись';
require_once ROOT.'/system/header.php';
?>
<div class="col-lg-4"></div>
<div class="col-sm-8 col-md-6 col-lg-4">
	<nav aria-label="breadcrumb">
		<ol class="breadcrumb">
			<div class="b-item">
				<li class="breadcrumb-item">
					<a href="/news">Новости</a>
				</li>
				<li class="breadcrumb-item active" aria-current="page"><?=$title?></li>
			</div>
		</ol>
	</nav>
	
	<script>
	$(document).ready(function () {
		var files;
		var alerts = $('#alerts');
		var message = $('#message').val();
		var progressBar = $('#progress');

		$('#my_file').on('change', function(){
			files = this.files;
		});
		
		$('#news-form').on('submit', function(e) {
			e.preventDefault();

			var formData = new FormData();
    				
			$.each(files, function(key, value) {
				formData.append(key, value);
			});
			formData.append('message', $('#message').val()); 
			
			$.ajax({
				url: '/AJAX/news/addNews.php',
				type: 'POST',
				data: formData,
				processData: false,
				contentType: false,
				dataType: 'json',
				beforeSend: function() {
					progressBar.show();
					$('#okButton').prop('disabled', true);
				},
				xhr: function() {
					var xhr = $.ajaxSettings.xhr();
					
					xhr.upload.addEventListener('progress', function(evt) {
						if(evt.lengthComputable) {
							var percentComplete = Math.ceil(evt.loaded / evt.total * 100);
							progressBar.html('<div class="progress-bar progress-bar-striped progress-bar-animated bg-danger" style="width: ' + percentComplete + '%"></div>');
						}
					}, false);
					
					return xhr;
				},
				success: function(json) {

					if (json['success'] == 1)
					{
						alerts.addClass("alert alert-success");
						alerts.html(json['comment']);
					}
					else
					{
						alerts.addClass("alert alert-danger");
						alerts.html(json['comment']);
					}
					
					setTimeout(function () {
						alerts.removeClass();
						alerts.html('');
						
						if(json['success'] == 1) location.href = json['url'];
					}, 2000);
				},
				error: function(xhr, ajaxOptions, thrownError) {
					alert(thrownError + "\r\n" + xhr.statusText + "\r\n " + xhr.responseText);
				},
				complete: function() {
					progressBar.hide().html('');
					$('#okButton').prop('disabled', false);
				}
			});
		});
	});
	</script>
	
	<div id="alerts"></div>
	
	<div class="card">
		<div class="card-body">
			<form action="/AJAX/news/addNews.php" method="POST" id="news-form">
				<div class="form-row">
					<div class="col-12">
						<div class="form-group">
							<label for="message" class="">Сообщение</label>
							<textarea class="form-control" name="message" id="message" rows="3"></textarea>
						</div>
						<div class="progress mb-3" id="progress" style="display: none;"></div>
					</div>
					<div class="col-8">
						
						<div class="form_upload btn btn-md btn-theme" style="border: 0!important;">
							<input type="file" name="my_file[]" id="my_file" style="z-index: 1;" multiple/>
							<i class="material-icons md-24">attach_file</i>
						</div>
						<button type="submit" class="btn btn-md btn-theme" style="border: 0!important;" name="photo" id="attachmentPhoto">
							<i class="material-icons md-24">add_photo_alternate</i>
						</button>
						<button type="submit" class="btn btn-md btn-theme" style="border: 0!important;" name="smile" id="smilePanel">
							<i class="material-icons md-24">sentiment_satisfied</i>
						</button>
					</div>
					<div class="col-4">
						<button type="submit" class="btn btn-theme-link btn-md float-right" id="okButton"><i class="material-icons md-24">send</i></button>
					</div>
				</div>
			</form>
		</div>
	</div>
</div>
<div class="col-lg-4"></div>
<?php
require_once ROOT.'/system/footer.php';
?>