<?php
require_once $_SERVER['DOCUMENT_ROOT'].'/system/App.php';
$title = $titleHeader = 'Оповещения';
require_once ROOT.'/system/header.php';
?>
<div class="col-lg-4"></div>
<div class="col-sm-8 col-md-6 col-lg-4">
	<nav aria-label="breadcrumb">
		<ol class="breadcrumb navig">
			<div class="b-item">
				<li class="breadcrumb-item">
					<a href="/">На главную</a>
				</li>
				<li class="breadcrumb-item active" aria-current="page"><?=$title?></li>
			</div>
		</ol>
	</nav>
	
	<script>
		$(document).ready(function () {
			var limit = 10;
			var alerts = $('#alerts');
			var offset = 0;
			var countAll = $('#count-all-notify');
			var countNew = $('#count-new-notify');
			
			$('#new-notify').tab('show');
			countNew.addClass('bg-dark');
			getNewNotifications();
			
			$('a[data-toggle="tab"]').on('show.bs.tab', function (e) {
				var controls = $(this).attr('aria-controls');
				
				if (controls == 'new-notify')
				{
					countNew.addClass('bg-dark');
					getNewNotifications();
				}
				else if(controls == 'all-notify')
				{
					countAll.addClass('bg-dark');
					getNotifications();
				}
			}).on('show.bs.tab', function(e) {
				var controls = $(e.relatedTarget).attr('aria-controls');
				$('#' + controls).tab('dispose');
			}).on('hidden.bs.tab', function(e) {
				$(this).find('span').removeClass('bg-dark');
			});
			
			function getNotifications() {
				var allNotifications = $('#all-notify');
				var noReadCounts = 0;
				
				$.ajax({
					url: '/AJAX/notifications/getNotifications.php',
		            type: 'POST',
		            data: {'offset': offset, 'limit': limit, 'type': 0},
		            dataType: 'json',
		            success: function(json) {
		
						if (json['success'] == 1)
						{
							countAll.text(json['response'].length);
							allNotifications.html('<div class="card"><ul class="list-group list-group-flush" id="all-response"></ul></div>');
							
							json['response'].forEach(function(notify) {
								var avatar = '<div class="media-avatar mr-2" style="background-image: url(' + notify.user_avatar + ');" alt=""></div>';
								var name = '<div class="media-body"><a href="/id' + notify.author_id + '" class="d-block text-light">' + notify.user_name + ' ' + notify.user_last_name + ' <span class="badge badge-theme badge-pill float-right mt-1">' + notify.user_date_last + '</span></a></div>';
								var message = '<div class="w-100 mt-2 text-small text-muted">' + notify.message + '</div>';
								$('#all-response').append('<li class="list-group-item" id="notify-' + notify.id + '"><div class="media">' + avatar + name + '</div>' + message + '</li>');
								
								if (notify.read == 0) noReadCounts++;
							});
						}
						else if (json['error'] == 1)
						{
							countAll.text('');
							allNotifications.html('<li class="text-center list-group-item">' + json.comment + '</li>');
						}
		            },
		            error: function(xhr, ajaxOptions, thrownError) {
		            	alert(thrownError + "\r\n" + xhr.statusText + "\r\n " + xhr.responseText);
		            },
		            complete: function() {
						$('#loader').hide();
						
						if (noReadCounts > 0)
						{
							$('#readNotify').removeClass('d-none');
						}
						else
						{
							$('#readNotify').addClass('d-none');
						}
					}
				});
			}
			
			
			function getNewNotifications() {
				var newNotifications = $('#new-notify');
				var noReadCounts = 0;
				
				$.ajax({
					url: '/AJAX/notifications/getNotifications.php',
		            type: 'POST',
		            data: {'offset': offset, 'limit': limit, 'type': 1},
		            dataType: 'json',
		            success: function(json) {
		
						if (json.success)
						{
							countNew.text(json['response'].length);
							newNotifications.html('<div class="card"><ul class="list-group list-group-flush" id="new-response"></ul></div>');
							
							json['response'].forEach(function(notify) {
								var avatar = '<div class="media-avatar mr-2" style="background-image: url(' + notify.user_avatar + ');" alt=""></div>';
								var name = '<div class="media-body"><a href="/id' + notify.author_id + '" class="d-block text-light">' + notify.user_name + ' ' + notify.user_last_name + ' <span class="badge badge-theme badge-pill float-right mt-1">' + notify.user_date_last + '</span></a></div>';
								var message = '<div class="w-100 mt-2 text-small text-muted">' + notify.message + '</div>';
								$('#new-response').append('<li class="list-group-item" id="notify-' + notify.id + '"><div class="media">' + avatar + name + '</div>' + message + '</li>');
								
								if (notify.read == 0) noReadCounts++;
							});
						}
						else if (json.error)
						{
							countNew.text('');
							newNotifications.html('<li class="text-center list-group-item">' + json.comment + '</li>');
						}
		            },
		            error: function(xhr, ajaxOptions, thrownError) {
		            	alert(thrownError + "\r\n" + xhr.statusText + "\r\n " + xhr.responseText);
		            },
		            complete: function() {
						$('#loader').hide();
						
						if (noReadCounts > 0)
						{
							$('#readNotify').removeClass('d-none');
						}
						else
						{
							$('#readNotify').addClass('d-none');
						}
					}
				});
			}
			
			$('#readNotify').on('click', function(e) {
				e.preventDefault();
				
				$.ajax({
					url: '/AJAX/notifications/readNotifications.php',
		            type: 'POST',
		            dataType: 'json',
		            success: function(json) {
						
						if (json.success)
						{
							alerts.addClass("alert mb-3 alert-success").html(json['comment']);
							
							getNewNotification();
							getNotifications();
						}
						else
						{
							alerts.addClass("alert mb-3 alert-danger").html(json['comment']);
						}
						setTimeout(function() {
							alerts.html('').removeClass();
						}, 2000);
					},
					error: function(xhr, ajaxOptions, thrownError) {
		            	alert(thrownError + "\r\n" + xhr.statusText + "\r\n " + xhr.responseText);
		            }
				});
			});
		});
	</script>
	
	<ul class="nav nav-pills nav-fill nav-pills-theme" id="myTab" role="tablist">
		<li class="nav-item "> <a class="nav-link left-radius color-theme active" id="new-notify-tab" data-toggle="tab" href="#new-notify" role="tab" aria-controls="new-notify" aria-selected="true">Новые<span id="count-new-notify" class="badge badge-info float-right mt-1"></span></a> </li> 
		<li class="nav-item "> <a class="nav-link color-theme" id="all-notify-tab" data-toggle="tab" href="#all-notify" role="tab" aria-controls="all-notify" aria-selected="false">Все <span id="count-all-notify" class="badge badge-info float-right mt-1"></span></a> </li> 
	</ul>
	<div id="alerts"></div>
	
	<a href="#readNotify" id="readNotify" class="btn btn-success btn-block mb-3 d-none">Пометить как прочитанные</a>
	<div class="tab-content" id="myTabContent"> 
		<div class="tab-pane fade show active" id="new-notify" role="tabpanel" aria-labelledby="new-notify-tab">
		</div>
		<div class="tab-pane fade" id="all-notify" role="tabpanel" aria-labelledby="all-notify-tab">
		</div>
	</div>
	
</div>
<div class="col-lg-4"></div>
<?php
require_once ROOT.'/system/footer.php';
?>
	