<?php
require_once($_SERVER['DOCUMENT_ROOT'].'/system/App.php');

if(isset($id) && !empty($id))
{
	$profile = $user->infoByID($id, 'id, login');
}
else
{
	$profile = $me;
}
if(empty($profile)) $core->redirect('/');

$title = 'Альбомы';
require_once ROOT.'/system/header.php';
?>

<div class="col-sm"></div>

<div class="col-sm-8 col-md-6 col-lg-4">

	<nav aria-label="breadcrumb">
		<ol class="breadcrumb">
			<div class="b-item">
				<li class="breadcrumb-item">
					<a href="/id<?=$profile['id']?>"><?=$profile['login']?></a>
				</li>
				<li class="breadcrumb-item active" aria-current="page"><?=$title?></li>
			</div>
		</ol>
	</nav>
	<script>
	$(document).ready(function()
	{
		$('.removeAlbum').on('click', function(e) {
			e.preventDefault();
			var data = $(this).attr('data-id');
			console.log(data);
			$.ajax({
				url: '/AJAX/albums/removeAlbum.php',
				type: 'post',
				data: {album_id:data},
				dataType: 'json',
				success: function(json) {
					$('#alerts').show();
					
					if(json['error'] == 1) {
						$('#alerts').html('<div class="alert alert-danger">'+json['comment']+'</div>');
					} else if(json['success'] == 1) {
						
						$('#album_' + data).remove();
						
						$('#alerts').html('<div class="alert alert-success">'+json['comment']+'</div>');
						
						location.href = json['url'];
					}
					setTimeout(function () {
						$('#alerts').html('');
					}, 1000);
				},
				error: function(xhr, ajaxOptions, thrownError) {
					alert(thrownError + "\r\n" + xhr.statusText + "\r\n " + xhr.responseText);
					location.href ='<?=HOME?>/albums';
				}
			});
		});
	});
	</script>

	<div class="mb-3">
	<a href="/albums/new" class="btn btn-theme-active btn-block">Создать альбом</a>
	</div>

<div id="alerts"></div>	
<div class="card">
	<ul class="list-group list-group-flush">
		<?php $albumsUser = $albums->albumsByID($profile['id'], 0, 20); if(!empty($albumsUser)): ?>
			<li class="list-group-item">
				<?php foreach($albumsUser as $list): $preview = $albums->previewAlbum($list['id']); ?>
					<span class="photo-album text-light" id="album_<?=$list['id']?>" style="background-image: url(/uploads/<?=(!empty($preview['name']) ? $preview['name'] : '')?>),linear-gradient(40deg,#d63031,#2f3640);"><?=(empty($preview['name']) ? 'Альбом пуст' : '')?>
							<span class="holder">
								<a href="/album/id<?=$list['id']?>/edit" class="btn btn-theme btn-sm mb-1">Редактировать</a><br>
								<a href="/album/id<?=$list['id']?>" class="btn btn-theme btn-sm mb-1">Просмотр</a><br>
								<a href="#deleteAlbum" class="btn btn-theme btn-sm mb-1 removeAlbum"  id="delete" data-id="<?=$list['id']?>">Удалить</a>
							</span>
					</span>
				<?php endforeach; ?>
			</li>
		<?php else: ?>
			<li class="list-group-item text-center text-muted">Пока что пусто...</li>
		<?php endif; ?>
	</ul>
</div>
</div>

<div class="col-sm">
</div>
<?php
require_once ROOT.'/system/footer.php';
?>