<?php
require_once $_SERVER['DOCUMENT_ROOT'].'/system/App.php';
$title = 'Новый альбом';
require_once ROOT.'/system/header.php';
?>
<div class="col-sm"></div>

<div class="col-sm-8 col-md-6 col-lg-4">

	<nav aria-label="breadcrumb">
		<ol class="breadcrumb">
			<div class="b-item">
				<li class="breadcrumb-item">
					<a href="/albums">Альбомы</a>
				</li>
				<li class="breadcrumb-item active" aria-current="page"><?=$title?></li>
			</div>
		</ol>
	</nav>

	<div id="alerts"></div>
	
	<div class="card">
		<script>
		$(document).ready(function () {
			var alerts = $('#alerts');
			var progressBar = $('#progress');
			var files;
        	
			$('#my_file').on('change', function(){
        		files = this.files;
        	});
        
			$('#okButton').on('click', function(e) {
				e.preventDefault();
				
				if(typeof files == 'undefined')
				{
					alerts.addClass('alert alert-danger');
					alerts.html('Выберите изображение');
					
					setTimeout(function () {
						alerts.removeClass();
						alerts.html('');
					}, 2000);
					
					return;
				}
				var formData = new FormData();
    				
            	$.each(files, function(key, value) {
            		formData.append(key, value);
            	});
				formData.append('name', $('#albumName').val()); 
				formData.append('form_id', $('#formId').val()); 
				
				$.ajax({
					url: '/AJAX/albums/newAlbum.php',
					type: 'POST',
					data: formData,
					dataType: 'json',
					processData: false,
					contentType: false,
					beforeSend: function() {
						progressBar.show();
						$('#okButton').prop('disabled', true);
					},
					xhr: function() {
						var xhr = $.ajaxSettings.xhr();
						
						xhr.upload.addEventListener('progress', function(evt) {
							if(evt.lengthComputable) {
								var percentComplete = Math.ceil(evt.loaded / evt.total * 100);
								progressBar.html('<div class="progress-bar progress-bar-striped progress-bar-animated bg-danger" style="width: ' + percentComplete + '%"></div>');
							}
						}, false);
						
						return xhr;
					},
					success: function(json) {
						
						if (json['success'] == 1)
						{
							alerts.addClass('alert alert-success');
							alerts.html(json['comment']);
						}
						else
						{
							alerts.addClass('alert alert-danger');
							alerts.html(json['comment']);
						}
						
						setTimeout(function () {
							alerts.removeClass();
							alerts.html('');
							
							if(json['success'] == 1) location.href = json['url'];
						}, 2000);
						
					},
					error: function(xhr, ajaxOptions, thrownError) {
						alert(thrownError + "\r\n" + xhr.statusText + "\r\n " + xhr.responseText);
					},
					complete: function() {
						progressBar.hide().html('');
						$('#okButton').prop('disabled', false);
					},
				});
			});
		});
		</script>
		
		<div class="card-body">
			<form action="/AJAX/albums/newAlbum.php" method="POST" id="newAlbum" enctype="multipart/form-data">
				<div class="form-group">
					<label class="form-check-label text-secondary">Название альбома</label>
					<input type="text" class="form-control" id="albumName" name="name">
		        </div>
				<div class="progress mb-3" id="progress" style="display: none;"></div>
				<div class="form_upload w-100 text-center">
					<input type="file" name="my_file[]" id="my_file" multiple/>
					<span class="btn btn-theme-active" id="uploadDiv">Загрузить изображение</span>
				</div>
				<input type="hidden" name="form_id" id="formId" value="<?=random_int(000000, 999999)?>">
			</form>
		</div>
		<div class="card-footer text-right">
			<button type="submit" class="btn btn-theme-active" id="okButton">Создать</button>   
        </div>
	</div>
	


</div>

<div class="col-sm"></div>
<?php
require_once ROOT.'/system/footer.php';
?>