<?php
require_once $_SERVER['DOCUMENT_ROOT'].'/system/App.php';
$title = 'Пользователи';
require_once ROOT.'/system/header.php';
?>
<div class="col-sm"></div>
<div class="col-sm-10 col-md-8 col-lg-4">
	
	<nav aria-label="breadcrumb">
		<ol class="breadcrumb navig">
			<div class="b-item">
				<li class="breadcrumb-item">
					<a href="/">На главную</a>
				</li>
				<li class="breadcrumb-item active" aria-current="page"><?=$title?></li>
			</div>
		</ol>
	</nav>
	
	<script>
		$(document).ready(function () {
			var alerts = $('#alerts');
			var allUsers = $('#all');
			var onlineUsers = $('#online');
			var searchUsers = $('#search');
			
			var countOnlineUsers = $('#count-online');
			var countSearchUsers = $('#count-search');
			var countAllUsers= $('#count-all');
			
			function getAllUsers() {
	            $.ajax({
	            url: '/AJAX/users/getAllUsers.php',
	            type: 'POST',
	            data: {offset: 0, limit: 10},
	            dataType: 'json',
	            success: function(json) {
					
					if (json['success'] == 1)
					{
						countAllUsers.text(json['response'].length);
						
						allUsers.html('<div class="card"><ul class="list-group list-group-flush" id="response-all-users"></ul></div>');
						
						json['response'].forEach(function(friend) {
							var avatar = '<div class="media-avatar mr-2" style="background-image: url(' + friend['avatar'] + ');" alt=""></div>';
							var name = '<div class="media-body"><a href="/id' + friend['id'] + '" class="d-block text-light">' + friend['name'] + ' ' + friend['last_name'] + ' <span class="badge badge-theme badge-pill float-right mt-1">' + friend['date_last'] + '</span></a></div>';
							var buttons = '<div class="row text-center mt-3"><span class="col"><a href="/mail/new/id' + friend['id'] + '" class="btn btn-theme-active btn-sm btn-block" data-id="' + friend['id'] + '">Написать</a></span><span class="col"><a href="#delete" class="d-none btn btn-theme-link btn-sm btn-block remove-friend" data-id="' + friend['id'] + '">Удалить</a></span></div>';
							
							$('#response-all-users').append('<li class="list-group-item" id="user-' + friend['id'] + '"><div class="media">' + avatar + name + '</div>' + buttons + '</li>');
							
							// $('#user-' + friend['id']).show(1000); // пытался делать красивое появление, но это дичь xD
						});
						
					}
					else
					{
						// countFriends.text('');
	                	allUsers.html('<div class="alert alert-danger">' + json['comment'] + '</div>');
	                }
	            },
	            error: function(xhr, ajaxOptions, thrownError) {
	            	alert(thrownError + "\r\n" + xhr.statusText + "\r\n " + xhr.responseText);
	            }
				});
			}
			
			function getOnlineUsers() {
				
	            $.ajax({
	            url: '/AJAX/users/getOnlineUsers.php',
	            type: 'POST',
	            data: {offset: 0, limit: 10},
	            dataType: 'json',
	            success: function(json) {
					
					if (json['success'] == 1)
					{
						countOnlineUsers.text(json['response'].length);
						
						onlineUsers.html('<div class="card"><ul class="list-group list-group-flush" id="response-online-users"></ul></div>');
						
						json['response'].forEach(function(friend) {
							var avatar = '<div class="media-avatar mr-2" style="background-image: url(' + friend['avatar'] + ');" alt=""></div>';
							var name = '<div class="media-body"><a href="/id' + friend['id'] + '" class="d-block text-light">' + friend['name'] + ' ' + friend['last_name'] + ' <span class="badge badge-theme badge-pill float-right mt-1">' + friend['date_last'] + '</span></a></div>';
							var buttons = '<div class="row text-center mt-3"><span class="col"><a href="/mail/new/id' + friend['id'] + '" class="btn btn-theme-active btn-sm btn-block" data-id="' + friend['id'] + '">Написать</a></span><span class="col"><a href="#delete" class="d-none btn btn-theme-link btn-sm btn-block remove-friend" data-id="' + friend['id'] + '">Удалить</a></span></div>';
							
							$('#response-online-users').append('<li class="list-group-item" id="online-user-' + friend['id'] + '"><div class="media">' + avatar + name + '</div>' + buttons + '</li>');
						});
						
					}
					else
					{
						countOnlineUsers.text('');
	                	onlineUsers.html('<div class="alert alert-danger">' + json['comment'] + '</div>');
	                }
	            },
	            error: function(xhr, ajaxOptions, thrownError) {
	            	alert(thrownError + "\r\n" + xhr.statusText + "\r\n " + xhr.responseText);
	            }
				});
			}
			
			getAllUsers();
			
			$('a[data-toggle="tab"]').on('show.bs.tab', function (e) {
				var controls = $(this).attr('aria-controls');
				
				if (controls == 'all')
				{
					countAllUsers.addClass('bg-dark');
					
					getAllUsers();
				}
				else if(controls == 'online')
				{
					countOnlineUsers.addClass('bg-dark');
					
					getOnlineUsers();
				}
				else if(controls == 'search')
				{
					countSearchUsers.addClass('bg-dark');
					
					$('#' + controls +'-form').show();
				}
				
			}).on('hidden.bs.tab', function(e) {
				var controls = $(e.target).attr('aria-controls');
				
				$('#' + controls).tab('dispose');
				$('#' + controls +'-form').hide();
				$(this).find('span').removeClass('bg-dark');
			});
			
			var sort = 0;
			var order = 0;
			var photo_only = 0;
			var online_only = 0;
			
			$(this).on('click', '#sort-input', function(e) {
				e.preventDefault();
				
				if(sort == 0)
				{
					sort = 1;
				}
				else
				{
					sort = 0;
				}
			}).on('click', '#order-input', function(e) {
				e.preventDefault();
				
				if(order == 0)
				{
					$(this).removeClass('btn-theme');
					$(this).addClass('btn-theme-active');
					
					order = 1;
				}
				else
				{
					$(this).removeClass('btn-theme-active');
					$(this).addClass('btn-theme');
					
					order = 0;
				}
			}).on('click', '#online-only', function(e) {
				e.preventDefault();
				
				if(online_only == 0)
				{
					$(this).removeClass('btn-theme');
					$(this).addClass('btn-theme-active');
					
					online_only = 1;
				}
				else
				{
					$(this).removeClass('btn-theme-active');
					$(this).addClass('btn-theme');
					
					online_only = 0;
				}
			}).on('click', '#photo-only', function(e) {
				e.preventDefault();
				
				if(photo_only == 0)
				{
					$(this).removeClass('btn-theme');
					$(this).addClass('btn-theme-active');
					
					photo_only = 1;
				}
				else
				{
					$(this).removeClass('btn-theme-active');
					$(this).addClass('btn-theme');
					
					photo_only = 0;
				}
			});
			
			$('#okButton').on('click', function(e) {
				e.preventDefault();

				var formData = {
					'query': $('#input-search').val(),
					'sort': sort,
					'order': order,
					'photo_only': photo_only,
					'online_only': online_only,
				};
				
				$.ajax({
		            url: '/AJAX/users/searchUsers.php',
		            type: 'POST',
		            data: formData,
		            dataType: 'json',
		            success: function(json) {
						
						if (json['success'] == 1)
						{
							countSearchUsers.text(json['response'].length);
							
							searchUsers.html('<div class="card"><ul class="list-group list-group-flush" id="response-search-users"></ul></div>');
							
							json['response'].forEach(function(friend) {
								var avatar = '<div class="media-avatar mr-2" style="background-image: url(' + friend['avatar'] + ');" alt=""></div>';
								var name = '<div class="media-body"><a href="/id' + friend['id'] + '" class="d-block text-light">' + friend['name'] + ' ' + friend['last_name'] + ' <span class="badge badge-theme badge-pill float-right mt-1">' + friend['date_last'] + '</span></a> <small class="text-muted">@' + friend['login'] + '</small> </div>';
								var buttons = '<div class="row text-center mt-3"><span class="col"><a href="/mail/new/id' + friend['id'] + '" class="btn btn-theme-active btn-sm btn-block" data-id="' + friend['id'] + '">Написать</a></span><span class="col"><a href="#delete" class="d-none btn btn-theme-link btn-sm btn-block remove-friend" data-id="' + friend['id'] + '">Удалить</a></span></div>';
								
								$('#response-search-users').append('<li class="list-group-item" id="online-user-' + friend['id'] + '"><div class="media">' + avatar + name + '</div>' + buttons + '</li>');
							});
							
						}
						else
						{
							countSearchUsers.text('');
		                	searchUsers.html('<div class="alert alert-danger">' + json['comment'] + '</div>');
		                }
		            },
		            error: function(xhr, ajaxOptions, thrownError) {
		            	alert(thrownError + "\r\n" + xhr.statusText + "\r\n " + xhr.responseText);
		            }
				});
			});
		});
	</script>
	
	<ul class="nav nav-pills nav-fill nav-pills-theme" id="myTab" role="tablist">
		<li class="nav-item "> <a class="nav-link left-radius color-theme active" id="all-tab" data-toggle="tab" href="#all" role="tab" aria-controls="all" aria-selected="true">Все <span id="count-all" class="badge badge-info float-right mt-1"></span></a> </li> 
		<li class="nav-item "> <a class="nav-link color-theme" id="online-tab" data-toggle="tab" href="#online" role="tab" aria-controls="online" aria-selected="false">В сети <span id="count-online" class="badge badge-info float-right mt-1"></span></a> </li> 
		<li class="nav-item "> <a class="nav-link right-radius color-theme" id="search-tab" data-toggle="tab" href="#search" role="tab" aria-controls="search" aria-selected="false">Поиск <span id="count-search" class="badge badge-info float-right mt-1"></span></a> </li> 
	</ul>

	<div id="alerts"></div>
	
	<div class="tab-content" id="myTabContent"> 
		<div class="tab-pane fade show active" id="all" role="tabpanel" aria-labelledby="all-tab"></div>
		<div class="tab-pane fade" id="online" role="tabpanel" aria-labelledby="online-tab"></div>
		
		<div id="search-form" style="display: none;">
			<form id="formSearchUsers">
				<div class="card">
					<div class="w-100" style="padding: 6px;">
						<div class="form-row">
							<div class="col-1">
								<button type="submit" class="btn btn-theme-link float-left p-0" id="sort">
									<i class="material-icons md-24">tune</i>
								</button>
							</div>
							<div class="col-10">
								<input type="search" class="form-control" name="query" id="input-search" placeholder="Начните искать...">
							</div>
							<div class="col-1">
								<button type="submit" class="btn btn-theme-link float-right p-0" id="okButton">
									<i class="material-icons md-24">search</i>
								</button>
							</div>
						</div>
					</div>
				</div>
				<div class="w-100 pb-1" style="white-space: nowrap; overflow-x: auto; margin-top: -10px;">
					<button type="submit" id="sort-input" class="btn btn-sm btn-theme" data-old-text="По дате регистрации" data-order="1">По дате регистрации</button>
					<button type="submit" id="order-input" class="btn btn-sm btn-theme" data-old-text="Сначала старые" data-order="asc">Сначала старые</button>
					<button type="submit" id="online-only" class="btn btn-sm btn-theme ml-1">Только онлайн</button>
					<button type="submit" id="photo-only" class="btn btn-sm btn-theme ml-1">Только с фотографией</button>
				</div>
			</form>
		</div>
		<div class="tab-pane fade mt-2" id="search" role="tabpanel" aria-labelledby="search-tab"></div>
	</div>

</div>
<div class="col-sm"></div>
<?php
require_once ROOT.'/system/footer.php';
?>