<?php
require_once $_SERVER['DOCUMENT_ROOT'].'/system/App.php';
$title = ($act == 'avatar' ? 'Обложка и аватар' : ($act == 'security' ? 'Безопасность' : ''));
$bcrumb = ($act == '' ? ['url' => '/', 'title' => 'На главную'] : ['url' => '/settings', 'title' => 'Настройки']);
require_once ROOT.'/system/header.php';
$user->access();
?>
<div class="col-sm"></div>
<div class="col-sm-8 col-md-6 col-lg-4">

<nav aria-label="breadcrumb">
	<ol class="breadcrumb">
		<div class="b-item">
			<li class="breadcrumb-item">
				<a href="<?=$bcrumb['url']?>"><?=$bcrumb['title']?></a>
			</li>
			<li class="breadcrumb-item active" aria-current="page">
				<a href="<?=$_SERVER['REQUEST_URI']?>"><?=$title?></a>
			</li>
		</div>
	</ol>
</nav>

<?
switch($act)
{
	case 'avatar':
	?>
	<script type="text/javascript">
	$(document).ready(function () {
	
		var progressBar = $('#progressbar'); // Прогрессбар
		// Удаление аватара
		$('#deleteAvatar').on('click', function(e) {
			e.preventDefault();
			
			$.ajax({
			url: '/AJAX/deleteAvatar.php',
			type: 'POST',
			data: '', // можно строкой, а можно, например, так: $('input[type="text"], input[type="radio"]:checked, input[type="checkbox"]:checked, select, textarea')
			dataType: 'json',
			success: function(json) {
				if(json['error'] == 1)
				{
					alert(json['comment']);
					location.href = '<?=HOME.$_SERVER['REQUEST_URI']?>';
				}
				else if(json['success'] == 1)
				{
					location.href = '<?=HOME.$_SERVER['REQUEST_URI']?>';
				}
			},
			error: function(xhr, ajaxOptions, thrownError) {
				alert('Ошибка: ' + thrownError + "\r\n" + xhr.statusText + "\r\n " + xhr.responseText);
				location.href = '<?=HOME.$_SERVER['REQUEST_URI']?>';
			}
			});
			
		});
		
		// Загрузка аватара
		$('#avatar').on('change', function(e) {
			e.preventDefault();
			progressBar.show();
			var $that = $('#uploadAvatar'), formData = new FormData($that.get(0));
			
			$.ajax({
			url: $that.attr('action'),
			type: $that.attr('method'),
			contentType: false,
			processData: false,
			data: formData,
			dataType: 'json',
			xhr: function() {
				var xhr = $.ajaxSettings.xhr();
				xhr.upload.addEventListener('progress', function(evt) {
				
					if(evt.lengthComputable) {
						var percentComplete = Math.ceil(evt.loaded / evt.total * 100);
						progressBar.val(percentComplete).text('Загружено ' + percentComplete + '%');
					}
				}, false);
				
				return xhr;
			},
			success: function(json)	{
				progressBar.hide();
				
				if(json['error'] == 1) {
					$('#alerts').html('<div class="alert alert-danger">'+json['comment']+'</div>');
					location.href = '<?=HOME.$_SERVER['REQUEST_URI']?>';
				} else if(json['success'] == 1) {
					$('#alerts').html('<div class="alert alert-success">'+json['comment']+'</div>');
					$('.upload-avatar').css({'background-image':'url('+json['avatar']+')'});
				}
				
				setTimeout(function () {
					$('#alerts').html('');
				}, 3000);
			
			},
			error: function(xhr, ajaxOptions, thrownError) {
				alert('Ошибка загрузки: ' + thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
				location.href = '<?=HOME.$_SERVER['REQUEST_URI']?>';
			}
			});
			
		});
		
		
		
		// Загрузка обложки
		$('#fon_avatar').on('change', function(e) {
			e.preventDefault();
			progressBar.show();
			var $that = $('#uploadCover'), formD = new FormData($that.get(0));
			
			$.ajax({
			url: $that.attr('action'),
			type: $that.attr('method'),
			contentType: false,
			processData: false,
			data: formD,
			dataType: 'json',
			xhr: function() {
				var xhr = $.ajaxSettings.xhr();
				xhr.upload.addEventListener('progress', function(evt) {
				
					if(evt.lengthComputable) {
						var percentComplete = Math.ceil(evt.loaded / evt.total * 100);
						progressBar.val(percentComplete).text('Загружено ' + percentComplete + '%');
					}
				}, false);
				
				return xhr;
			},
			success: function(json)	{
				progressBar.hide();
				
				if(json['error'] == 1) {
					$('#alerts').html('<div class="alert alert-danger">'+json['comment']+'</div>');
				} else if(json['success'] == 1) {
					$('#alerts').html('<div class="alert alert-success">'+json['comment']+'</div>');
					$('.profile-user-fon').css({'background-image':'url('+json['cover']+')'});
				}
				
				setTimeout(function () {
					$('#alerts').html('');
				}, 2000);
			
			},
			error: function(xhr, ajaxOptions, thrownError) {
				alert('Ошибка загрузки: ' + thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
				location.href = '<?=HOME.$_SERVER['REQUEST_URI']?>';
			}
			});
			
		});
		
	});
	</script>
	<div id="alerts"></div>
	<div class="card">
		<div class="profile-user">
			<div class="profile-user-fon" style="background-image: url(<?=$me['fon_avatar']?>);">
				<span class="upload-cover badge badge-info float-right badge-pill" style="position: absolute; top: 5px; right: 8px; background-color: rgba(0,0,0,0.5);">
					<?=(empty($me['fon_avatar']) || $me['fon_avatar'] == '/design/img/cover.jpg' ? 'Загрузить обложку' : 'Сменить обложку')?>
					<form action="/AJAX/uploadCover.php" method="POST" id="uploadCover">
						<input type="file" name="fon_avatar" style="position: absolute; top: 0; left: 0; opacity: 0; width: 100%; height: 100%; z-index: 1000;" id="fon_avatar">
					</form>
				</span>
				<div class="form_upload text-center pt-5 mt-5">
					<form action="/AJAX/uploadAvatar.php" method="POST" id="uploadAvatar">
						<span class="upload-avatar" style="background-image: url(<?=$me['avatar']?>);">
								<input type="file" name="avatar" style="z-index: 1;" id="avatar">
								<div class="text-center text-light w-100 font-weight-bold" id="avatarPriview" style="padding-top: 88px; height: 100%; border-radius: 100%; position: relative; top: 0; left: 0; background-color: rgba(0,0,0,0.4);">
									<?=(empty($me['avatar']) || $me['avatar'] == '/design/img/avatar.jpg' ? 'Загрузить аватар' : 'Сменить аватар')?>
								</div>
						</span>
					</form>
				</div>
			</div>
		</div>
		<div class="card-body text-center">
			<progress id="progressbar" value="0" max="100" style="display: none;"></progress>
			
			<div class="form-row ">
				<?php
				if(!empty($me['avatar']) && $me['avatar'] != '/design/img/avatar.jpg')
				{
				?>
				<div class="col-12">
					<a href="#deleteAvatar" class="btn btn-danger text-light btn-sm" id="deleteAvatar">Удалить аватар</a>
				</div>
				<?php
				}
				if(!empty($me['fon_avatar']) && $me['fon_avatar'] != '/design/img/cover.jpg')
				{
				?>
				<div class="col-6 d-none">
					<a href="#deleteCover" class="btn btn-danger text-light btn-sm" id="deleteCover">Удалить обложку</a>
				</div>
				<?php
				}
				?>
		</div>
		</div>
	</div>
	<?php
	break;
	case 'security':
	?>
	
	<script type="text/javascript">
	$(document).ready(function () {
		
		$('#form').submit(function(e) {
			e.preventDefault();
			var formData = $('#form').serialize();
			
			$.ajax({
			url: '/AJAX/securityUser.php',
			type: 'GET',
			data: formData, // можно строкой, а можно, например, так: $('input[type="text"], input[type="radio"]:checked, input[type="checkbox"]:checked, select, textarea')
			dataType: 'json',
			success: function(json) {
				$('#alerts').show();
				
				if(json['error'] == 1) {
					$('#alerts').html('<div class="alert alert-danger">'+json['comment']+'</div>');
				} else if(json['success'] == 1) {
					$('#alerts').html('<div class="alert alert-success">'+json['comment']+'</div>');
				}
				setTimeout(function () {
					$('#alerts').hide();
				}, 2000);
			},
			error: function(xhr, ajaxOptions, thrownError) {
				alert(thrownError + "\r\n" + xhr.statusText + "\r\n " + xhr.responseText);
			}
			});
			
		});
	});
	</script>
	
	<div class="card">
		<div class="card-body">
			<div id="alerts"></div>
			<form action="/AJAX/securityUser.php" method="POST" id="form">
				<div class="form-group">
					<label for="InputPassword" class="form-check-label text-info">Старый пароль</label>
					<input type="password" class="form-control input-theme input-md" id="InputPassword" name="password">
				</div>
				<div class="form-group">
					<label for="InputNewPassword" class="form-check-label text-info">Новый пароль</label>
					<input type="text" class="form-control input-theme input-md" id="InputNewPassword" name="new_password">
				</div>
				<button type="submit" class="btn btn-md btn-theme-active btn-block" id="ok" name="ok">Изменить</button>
			</form>
		</div>
	</div>
	<?php
	break;
	default:
	?>	
	
	<div class="card">
		<ul class="list-group list-group-flush">
			<a href="/profile/edit" class="list-group-item color-theme">Редактировать анкету</a>
			<a href="/settings/security" class="list-group-item color-theme">Настройки безопасности</a>
			<a href="/settings/avatar" class="list-group-item color-theme"><?=(empty($me['avatar']) || $me['avatar'] == '/design/img/ava.jpg' ? 'Загрузить' : 'Сменить')?> аватар</a>
		</ul>
	</div>
	<?php
	break;
}
?>
</div>
<div class="col-sm"></div>
<?php
require ROOT.'/system/footer.php';
?>