$(document).ready(function() {
	var files;
	var alerts = $('#alerts');
	
	$('#avatar').on('change', function() {
		files = this.files;
		if(typeof files == 'undefined') return;
		
		var formData = new FormData();
		
		$.each(files, function(key, value) {
			formData.append(key, value);
		});
		
		$.ajax({
			url: '/AJAX/profile/avatar/uploadAvatar.php',
			type: 'POST',
			data: formData,
			dataType: 'json',
			processData: false,
			contentType: false,
			xhr: function() {
				var xhr = $.ajaxSettings.xhr();
				
				xhr.upload.addEventListener('progress', function(evt) {
					if(evt.lengthComputable) {
						var percentComplete = Math.ceil(evt.loaded / evt.total * 100);
						console.log(percentComplete);
					}
				}, false);
				
				return xhr;
			},
			success: function(json) {
				if (json['success'] == 1)
				{
					alerts.addClass('alert alert-success');
					alerts.html(json['comment']);
					
					$('.profile-user-fon').css('background-image', 'url(' + json.avatar + ')');
				}
				else
				{
					alerts.addClass('alert alert-danger');
					alerts.html(json['comment']);
				}
				
				setTimeout(function () {
					alerts.removeClass();
					alerts.html('');
				}, 2000);
			},
			error: function(xhr, ajaxOptions, thrownError) {
				alert(thrownError + "\r\n" + xhr.statusText + "\r\n " + xhr.responseText);
			}
		});
	});
});