<?php

class Albums {
	
	public function albumsByID($user_id, $offset = 0, $count = 10)
	{
		if(!empty($user_id))
		{
			$query = Base::query(
			'SELECT * FROM `albums` WHERE `user_id` = :user_id ORDER BY `id` DESC LIMIT :offset,:count', [
			'user_id' => $user_id,
			'offset/int' => $offset,
			'count/int' => $count,
			],
			'arr'
			);
		}
		else $query = NULL;
		
		if(!empty($query))
		{
			$result = $query;
		}
		else $result = NULL;
		
		return $result;
	}
	
	public function getByURL($url)
	{
		if(!empty($url))
		{
			$query = Base::get(
			'albums', [
			'url' => $url
			]
			);
		}
		else $query = NULL;
		
		if(!empty($query))
		{
			$result = $query;
		}
		else $result = NULL;
			
		return $result;
	}
	
	public function getByID($id)
	{
		if(!empty($id))
		{
			$query = Base::get('albums', $id);
		}
		else $query = NULL;
		
		if(!empty($query))
		{
			$result = $query;
		}
		else $result = NULL;
			
		return $result;
	}
	
	
	public function photosByID($album_id, $offset = 0, $count = 10)
	{
		if(!empty($album_id))
		{
			$query = Base::query(
			'SELECT * FROM `photos` WHERE `album_id` = :album_id ORDER BY `id` DESC LIMIT :offset,:count', [
			'album_id' => $album_id,
			'offset/int' => $offset,
			'count/int' => $count,
			],
			'arr'
			);
		}
		else $query = NULL;
		
		if(!empty($query))
		{
			$result = $query;
		}
		else $result = NULL;
			
		return $result;
	}
	
	public function photoByName($name)
	{
		if(!empty($name))
		{
			$query = Base::get('photos', [
			'name' => $name
			]);
		}
		else $query = NULL;
		
		if(!empty($query))
		{
			$result = $query;
		}
		else $result = NULL;
			
		return $result;
	}
    
    public function photoByID($id)
	{
		if(!empty($id))
		{
			$query = Base::get('photos', $id);
		}
		else $query = NULL;
		
		if(!empty($query))
		{
			$result = $query;
		}
		else $result = NULL;
			
		return $result;
	}
    
	public function previewAlbum($album_id)
	{
		if(!empty($album_id))
		{
			$query = $array = Base::query(
			'SELECT * FROM `photos` WHERE `album_id` = :id ORDER BY `id` DESC LIMIT 1', [
			'id' => $album_id,
			],
			'arr'
			);
		}
		else $query = NULL;
		
		if(!empty($query))
		{
			$result = $query[0];
		}
		else $result = NULL;
		
		return $result;
	}
}

?>