<?php

class Core {
	
	public static function alert($string, $style='theme')
	{
		if(!empty($string))
		{
			return '<div class="alert alert-'.$style.' text-center">'.$string.'</div>';
		} else return false;
	}
	
	public function redirect($url)
	{
		if(!empty($url))
		{
			header('Location:'.$url);
			exit;
		} 
	}
	
	public function hash(int $count = 5)
	{
		if($count > 0)
		{
			return bin2hex(random_bytes($count));
		}
	}
	
	public function setLog($text, $file = null, $type = 'info')
	{
	    if(empty($file))
	    {
	        $file = ROOT.'/logs/'.$type.'-'.date('H:i').'.txt';
	    }
		else
		{
		    $file = ROOT.'/logs/'.$file.'.txt';
		}
		
		if(!empty($text))
		{
			if(file_put_contents($file, $text, FILE_APPEND | LOCK_EX))
			{
				$result = true;
			}
			else $result = false;
			
		}
		else $result = NULL;
		
		return $result;
	}
}


?>