<?php

class Friends
{
	
	public function get(int $offset = 0, int $count = 10)
	{
		$response = false;
		
		if (!empty($count))
		{
			$request = Base::query(
				'SELECT `friends`.*, `user`.`name` as `name`, `user`.`last_name` as `last_name`, `user`.`id` as `friend_id`, `user`.`avatar` as `friend_avatar`, `user`.`date_last` as `date_last` FROM `friends`, `user` WHERE `user`.`id` <> :id AND (`user`.`id` = `friends`.`user_id` OR `user`.`id` = `friends`.`subscriber_id`) AND (`friends`.`user_id` = :id OR `friends`.`subscriber_id` = :id) AND `friends`.`status` = 1 LIMIT :offset,:count', [
					'id/int' => App::$me['id'],
					'offset/int' => $offset,
					'count/int' => $count,
				], 'arr'
			);
			
			if (is_array($request))
			{
				foreach($request as $key => $value)
				{
					$request[$key]['date_last'] = App::$sys->time($value['date_last']);
					$request[$key]['friend_avatar'] = empty($value['friend_avatar']) ? '/design/img/avatar.jpg' : $value['friend_avatar'];
				}
				
				$response = $request;
			}
		}
		return $response;
	}
	
	public function getOnline(int $offset = 0, int $count = 10)
	{
		$response = false;
		
		if (!empty($count))
		{
			$request = Base::query(
				'SELECT `friends`.*, `user`.`name` as `name`, `user`.`last_name` as `last_name`, `user`.`id` as `friend_id`, `user`.`avatar` as `friend_avatar`, `user`.`date_last` as `date_last` FROM `friends`, `user` WHERE `user`.`id` = `friends`.`subscriber_id` AND `friends`.`user_id` = :id AND `friends`.`status` = 1 AND `user`.`date_last` > :time LIMIT :offset,:count', [
					'id/int' => App::$me['id'],
					'time/int' => (time()-300),
					'offset/int' => $offset,
					'count/int' => $count,
				], 'arr'
			);
			
			if (is_array($request))
			{
				foreach($request as $key => $value)
				{
					$request[$key]['date_last'] = App::$sys->time($value['date_last']);
				}
				
				$response = $request;
			}
		}
		return $response;
	}
	
	
	public function getSubscribers(int $offset = 0, int $count = 10)
	{
		$response = false;
		
		if (!empty($count))
		{
			$request = Base::query(
				'SELECT `friends`.*, `user`.`name` as `name`, `user`.`last_name` as `last_name`, `user`.`id` as `friend_id`, `user`.`avatar` as `friend_avatar`, `user`.`date_last` as `date_last` FROM `friends`, `user` WHERE (`user`.`id` = `friends`.`subscriber_id` AND `friends`.`user_id` = :id) AND `friends`.`status` = 0 LIMIT :offset,:count', [
					'id/int' => App::$me['id'],
					'offset/int' => $offset,
					'count/int' => $count,
				], 'arr'
			);
			
			if (is_array($request))
			{
				foreach($request as $key => $value)
				{
					$request[$key]['date_last'] = App::$sys->time($value['date_last']);
				}
				
				$response = $request;
			}
		}
		return $response;
	}
	
	public function add(int $who_id, int $whom_id, string $message = '')
	{
		$response = false;
		
		if (!empty($who_id) && !empty($whom_id))
		{
			$request = Base::add('friends', [
				'time/int' => TIME,
				'status/int' => 0,
				'user_id/int' => $whom_id,
				'message' => $message,
				'subscriber_id/int' => $who_id,
			]);
			
			if ($request) $response = true;
		}
		return $response;
	}
	
	public function remove(int $user_id, int $who_id)
	{
		$response = false;
		
		if (!empty($user_id) && !empty($who_id))
		{
			if ($appId = $this->isFriends($user_id, $who_id))
			{
				$response = Base::update('friends', $appId, [
					'status' => 2,
				]);
			}
		}
		return $response;
	}
	
	public function acceptApplication(int $user_id, int $who_id)
	{
		$response = false;
		
		if (!empty($user_id) && !empty($who_id))
		{
			if ($appId = $this->isSubscriber($user_id, $who_id))
			{
				$response = Base::update('friends', $appId, [
					'status' => 1
				]);
			}
		}
		return $response;
	}
	
	public function rejectApplication(int $user_id, int $who_id)
	{
		$response = false;
		
		if (!empty($user_id) && !empty($who_id))
		{
			if ($appId = $this->isSubscriber($user_id, $who_id))
			{
				$response = Base::update('friends', $appId, [
					'status' => 2
				]);
			}
		}
		return $response;
	}
	
	public function cancelApplication(int $user_id, int $who_id)
	{
		$response = false;
		
		if (!empty($user_id) && !empty($who_id))
		{
			if ($appId = $this->isSubscriber($who_id, $user_id))
			{
				$response = Base::remove('friends', $appId);
			}
		}
		return $response;
	}
	
	public function isFriends(int $user_id, int $who_id)
	{
		$response = false;
		
		if (!empty($user_id) && !empty($who_id))
		{
			$request = Base::query('SELECT * FROM `friends` WHERE (`user_id` IN (:user_id, :who_id) AND `subscriber_id` IN (:user_id, :who_id)) AND `status` = 1 LIMIT 1', [
					'user_id/int' => $user_id,
					'who_id/int' => $who_id,
			]);
			
			if ($request && $request['status'] == 1) $response = $request['id'];
		}
		return $response;
	}
	
	public function isSubscriber(int $user_id, int $who_id)
	{
		$response = false;
		
		if (!empty($user_id) && !empty($who_id))
		{
			$request = Base::query('SELECT * FROM `friends` WHERE (`user_id` = :user_id AND `subscriber_id` = :who_id) AND `status` = 0 LIMIT 1', [
					'user_id/int' => $user_id,
					'who_id/int' => $who_id,
			]);
			
			if ($request && $request['status'] == 0) $response = $request['id'];
		}
		return $response;
	}
	
	public function count(int $user_id)
	{
		return Base::query('SELECT COUNT(`id`) FROM `friends` WHERE (`user_id` = :user_id OR `subscriber_id` = :user_id) AND `status` = 1', [
			'user_id' => $user_id,
		]);
	}
	
	public function countSubscribers(int $user_id)
	{
		return Base::query('SELECT COUNT(`id`) FROM `friends` WHERE `user_id` = :user_id AND `status` = 0', [
			'user_id' => $user_id,
		]);
	}
}
