<?php

class News 
{
	
	public function get(int $offset = 0, int $count = 10)
	{
		$response = false;
		
		if (!empty($count))
		{
			$response = Base::query(
				'SELECT `news`.*, `user`.`name` as `user_name`, `user`.`last_name` as `user_last_name`, `user`.`date_last` as `user_date_last` FROM `news`, `user` WHERE `user`.`id` = `news`.`user_id` ORDER BY `news`.`time` DESC LIMIT :offset,:count', [
					'offset/int' => $offset,
					'count/int' => $count,
				],
				'arr'
			);
		}
		return $response;
	}
	
	public function getById(int $news_id)
	{
		$response = false;
		
		if (!empty($news_id))
		{
			$response = Base::query(
				'SELECT `news`.*, `user`.`name` as `user_name`, `user`.`last_name` as `user_last_name`, `user`.`date_last` as `user_date_last` FROM `news`, `user` WHERE `user`.`id` = `news`.`user_id` AND `news`.`id` = :id LIMIT 1', [
					'id/int' => $news_id,
			]);
		}
		return $response;
	}
	
	public function getFiles(int $id, int $offset = 0, int $count = 10)
	{
		$response = false;
		
		if (!empty($id) && !empty($count))
		{
			$response = Base::query(
				'SELECT * FROM `news_files` WHERE `news_id` = :news_id ORDER BY `time` DESC LIMIT :offset,:count', [
					'offset/int' => $offset,
					'count/int' => $count,
					'news_id/int' => $id,
				],
				'arr'
			);
		}
		return $response;
	}
	
	public function countLikes(int $news_id)
	{
		$response = false;
		
		if (!empty($news_id))
		{
			$response = Base::count('news_likes', 'news_id = :id AND type = 1', [
				'id/int' => $news_id,
			]);
		}
		return $response;
	}
	
	public function countViews(int $news_id)
	{
		$response = false;
		
		if (!empty($news_id))
		{
			$response = Base::count('news_views', 'news_id = :id', [
				'id/int' => $news_id,
			]);
		}
		return $response;
	}
	
	public function isLiked(int $news_id, int $type = 1)
	{
		$response = false;
		
		if (!empty($news_id))
		{
			$response = Base::get('news_likes', 'news_id = :id AND user_id = :user_id AND type = :type', [
				'id/int' => $news_id,
				'user_id/int' => App::$me['id'],
				'type/int' => $type,
			]);
		}
		return $response;
	}
	
	public function addLike(int $news_id, int $type = 0)
	{
		$response = false;
		
		if (!empty($news_id))
		{
			if ($likeId = $this->isLiked($news_id, 0))
			{
				$response = Base::update('news_likes', $likeId, [
					'type' => 1,
					'time' => TIME,
				]);
			}
			elseif ($likeId = $this->isLiked($news_id))
			{
				$response = Base::update('news_likes', $likeId, [
					'type' => 0,
					'time' => TIME,
				]);
			}
			else
			{
				$response = Base::add('news_likes', [
					'type' => 1,
					'time' => TIME,
					'user_id' => App::$me['id'],
					'news_id' => $news_id,
				]);
			}
		}
		return $response;
	}
}
