<?php

class Notifications
{
	protected $user = false;
	
	public function __construct()
	{
		$this->user = isset(App::$me['id']) && !empty(App::$me['id']) ? (object) App::$me : false;
	}
	
	public function get(int $offset = 0, int $count = 10)
	{
		$response = false;
		
		if (!empty($count) && $this->user)
		{
			$query = Base::query(
				'SELECT `notifications`.*, `user`.`name` as `user_name`, `user`.`last_name` as `user_last_name`, `user`.`date_last` as `user_date_last`, `user`.`avatar` as `user_avatar` FROM `notifications`, `user` WHERE `user`.`id` = `notifications`.`author_id` AND `notifications`.`user_id` = :user_id ORDER BY `notifications`.`time` DESC LIMIT :offset,:count', [
					'offset/int' => $offset,
					'count/int' => $count,
					'user_id/int' => $this->user->id,
				],
				'arr'
			);
			
			if (!empty($query) && is_array($query))
			{
				foreach($query as $key => $value)
				{
					$query[$key]['time'] = App::$sys->time($value['time']);
					$query[$key]['user_avatar'] = empty($value['user_avatar']) ? HOME.'/design/img/avatar.jpg' : HOME.$value['user_avatar'];
					$query[$key]['user_date_last'] = App::$sys->time($value['user_date_last']);
					
				}
				$response = $query;
			}
		}
		return $response;
	}
	
	public function getNew(int $offset, int $count)
	{
		$response = false;
		
		if (!empty($count) && $this->user)
		{
			$query = Base::query(
				'SELECT `notifications`.*, `user`.`name` as `user_name`, `user`.`last_name` as `user_last_name`, `user`.`date_last` as `user_date_last`, `user`.`avatar` as `user_avatar` FROM `notifications`, `user` WHERE `user`.`id` = `notifications`.`author_id` AND `notifications`.`read` = 0 AND `notifications`.`user_id` = :user_id ORDER BY `notifications`.`time` DESC LIMIT :offset,:count', [
					'offset/int' => $offset,
					'count/int' => $count,
					'user_id/int' => $this->user->id,
				],
				'arr'
			);
			
			if (!empty($query) && is_array($query))
			{
				foreach($query as $key => $value)
				{
					$query[$key]['time'] = App::$sys->time($value['time']);
					$query[$key]['user_avatar'] = empty($value['user_avatar']) ? HOME.'/design/img/avatar.jpg' : HOME.$value['user_avatar'];
					$query[$key]['user_date_last'] = App::$sys->time($value['user_date_last']);
				}
				$response = $query;
			}
		}
		return $response;
	}
	
	public function addByUserId(int $user_id)
	{
		$response = false;
		
		
		return $response;
	}
	
	public function read()
	{
		$response = false;
		
		if ($this->user)
		{
			$query = Base::update('notifications', [
				'user_id' => $this->user->id,
			], [
				'read' => 1,
			]);
			if ($query) $response = true;
		}
		return $response;
	}
	
	
}
