<?php
class Rating
{
    protected $types = [
        'rang',
        'money'
    ];
    
    public function getUsers($type, $offset = 0, $count = 20)
    {
        if (! in_array($type, $this->types))
        {
            throw new \Exception('Несуществующий тип рейтинга.');
        }
        
        return Base::query(
            'SELECT * FROM `user` ORDER BY `'.Base::safely($type).'` DESC LIMIT :offset, :count', [
                'offset/int' => $offset,
                'count/int' => $count,
            ], 
            'arr'
        );
    }
}
?>