<?php 

class Settings {
    
    public function __construct()
    {
    	$arrSettings = Base::get('settings', 1);
    	$putSettings = json_encode($arrSettings, JSON_UNESCAPED_UNICODE);
    
    	if (!is_dir(PATH_SYS_FILES)) mkdir(PATH_SYS_FILES, 0777);
    	
    	if (!file_exists (FILE_SETTINGS))
    	{
    		file_put_contents(FILE_SETTINGS, $putSettings);
    	}
    	else
    	{
    		$getSettings = $this->getSettings ();
    
	    	if(!empty($getSettings))
	    	{
		    	foreach($arrSettings as $keySettings => $valSettings)
		    	{
					if ($keySettings != 'id') $this->$keySettings = $valSettings;
		    	}
	    	}
    	}
    }
    
    public function getSettings()
    {
    	$getSettings = json_decode (file_get_contents (FILE_SETTINGS));
    	
    	if (!empty ($getSettings))
    	{
    		return $getSettings;
    	}
    	else return false;
    }
    
    public function setSettings($updateFields = [])
    {
    	$response = false;
    
    	if (is_array ($updateFields) || !empty ($updateFields))
    	{
    		$arrSettings = Base::get('settings', 1);
    		$updateSettings = null;
    
    		foreach ($updateFields as $keyField => $valField)
    		{
    			
    			if (array_key_exists($keyField, $arrSettings) && !empty ($valField))
    			{
    				$updateSettings = Base::update('settings', 1, [$keyField => $valField]);
				}
			}
			
			if ($updateSettings == true)
			{
				$putSettings = json_encode(Base::get('settings', 1), JSON_UNESCAPED_UNICODE);
				
				$response = file_put_contents(FILE_SETTINGS, $putSettings);
			}
		}
		return $response;
    }
}