<?php

class Users
{
	
	public function get(int $offset = 0, int $count = 10)
	{
		$response = false;
		
		if (!empty($count))
		{
			$request = Base::query(
				'SELECT `name`, `last_name`, `date_last`, `avatar`, `id` FROM `user` ORDER BY `date_last` DESC LIMIT :offset,:count', [
					'offset/int' => $offset,
					'count/int' => $count,
				],
				'arr'
			);
			
			if (!empty($request) && is_array($request))
			{
				foreach ($request as $key => $value)
				{
					$request[$key]['date_last'] = App::$sys->time($request[$key]['date_last']);
					$request[$key]['avatar'] = (!empty($request[$key]['avatar']) ? HOME.$request[$key]['avatar'] : HOME.'/design/img/avatar.jpg');
					
				}
				$response = $request;
			}
		}
		return $response;
	}
	
	public function getOnline(int $offset = 0, int $count = 10)
	{
		$response = false;
		
		if (!empty($count))
		{
			$request = Base::query(
				'SELECT `name`, `last_name`, `date_last`, `avatar`, `id` FROM `user` WHERE `date_last` > :time ORDER BY `date_last` DESC LIMIT :offset,:count', [
					'time/int' => (time()-300),
					'offset/int' => $offset,
					'count/int' => $count,
				],
				'arr'
			);
			
			if (!empty($request) && is_array($request))
			{
				foreach ($request as $key => $value)
				{
					$request[$key]['date_last'] = App::$sys->time($request[$key]['date_last']);
					$request[$key]['avatar'] = (!empty($request[$key]['avatar']) ? HOME.$request[$key]['avatar'] : HOME.'/design/img/avatar.jpg');
					
				}
				$response = $request;
			}
		}
		return $response;
	}
	
	public function search(string $query, $params = [])
	{
		$response = false;
		
		if (!empty($query))
		{
			$sort = isset($params['sort']) && $params['sort'] == 1 ? 'date_reg' : 'date_last';
			$order = isset($params['order']) && $params['order'] == 1 ? 'DESC' : 'ASC';
			$fields = isset($params['fields']) && !empty($params['fields']) ? App::$sys->protect($params['fields']) : 'id, login, name, last_name, date_last, avatar, date_reg';
			$count = isset($params['count']) && !empty($params['count']) ? (int) $params['count'] : 10;
			$offset = isset($params['offset']) && !empty($params['offset']) ? (int) $params['offset'] : 0;
			$photoOnly = (isset($params['photo_only']) && $params['photo_only'] == 1 ? "AND `avatar` <> ''" : null);
			$onlineOnly = (isset($params['online_only']) && $params['online_only'] == 1 ? 'AND `date_last` > '.(TIME-300) : null);
			
			$request = Base::query(
				'SELECT '.$fields.' FROM `user` WHERE (`login` LIKE :query OR `name` LIKE :query OR `last_name` LIKE :query) '.$photoOnly.$onlineOnly.' ORDER BY `'.$sort.'` '.$order.' LIMIT 10', [
					'query' => '%'.$query.'%',
				],
				'arr'
			);
			
			if (!empty($request) && is_array($request))
			{
				foreach ($request as $key => $value)
				{
					if (isset($request[$key]['avatar'])) $request[$key]['avatar'] = (!empty($request[$key]['avatar']) ? HOME.$request[$key]['avatar'] : HOME.'/design/img/avatar.jpg');
					if (isset($request[$key]['date_reg'])) $request[$key]['date_reg'] = App::$sys->time($request[$key]['date_reg']);
					if (isset($request[$key]['date_last'])) $request[$key]['date_last'] = App::$sys->time($request[$key]['date_last']);
				}
				$response = $request;
			}
		}
		return $response;
	}
	
}