<!DOCTYPE html>
<html lang="ru">
    <head> 
        <!-- Мета-теги -->
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title><?=(empty($title) ? $title = $_SERVER['HTTP_HOST'] : $title)?></title>
        
        <!-- favicon -->
        <link rel="shortcut icon" href="/favicon.ico" type="image/x-icon">
        <link rel="icon" href="/favicon.ico" type="image/x-icon">
        
           <!-- Стили -->
        <link href="/design/css/bootstrap.min.css" rel="stylesheet">
        <link href="/design/theme/dark_red/style.css" rel="stylesheet">
        <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
        <link rel="stylesheet" href="/design/css/md-icons.css">
        <link rel="stylesheet" href="/design/css/emoji.css">
        <link rel="stylesheet" href="/design/css/baguetteBox.min.css">

	
        <!-- Скрипты -->
        <script src="/design/js/jquery-3.3.1.min.js"></script>
        <script src="/design/js/emoji.js"></script>
        <script src="/design/js/popper.min.js"></script>
        <script src="/design/js/bootstrap.min.js"></script>
        <script src="/design/js/jquery.form.js"></script>
        <script src="https://cdn.rawgit.com/davidshimjs/qrcodejs/gh-pages/qrcode.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/baguettebox.js/1.8.1/baguetteBox.min.js"></script>

        <!-- Меню -->
        <script>
        function switchMenu(p) {
	        if (p === 1) 
	        {
	            document.querySelector(".menu-container").classList.add("active")
	        } 
	        else if (p === 0) 
	        {
	            document.querySelector(".menu-container").classList.remove("active")
	        } 
	        else 
	        {
	            document.querySelector(".menu-container").classList.toggle("active")
	        } 
        }
        
        function replaceEmoji()
        {
        	var textReplace = document.getElementById('body').innerHTML;
			document.getElementById('body').innerHTML = window.emoji.replace(textReplace);
        }
        </script>
    </head>
    <body id="body" onload="replaceEmoji();">
    <div class="menu-container">
    <div class="menu-bg" onclick="switchMenu(0)"></div>
    <div class="menu" style="overflow-y: auto; height: 110%;">
        <div class="menu-content">
            <?php if(!empty($me)): ?>
                <div class="menu-user">
                    <div class="menu-user-fon" style="background-image: url(<?=$me['fon_avatar']?>), linear-gradient(40deg,#d63031,#2f3640)!important;">
                        <a href="/id<?=$me['id'] ?>" class="badge badge-pill badge-theme" style="position: absolute; top: 5px; left: 8px;"><?=$me['login'] ?></a>
                        <a href="/admin" class="badge badge-pill badge-danger" style="position: absolute; top: 5px; right: 8px;"><?=($me['access'] == 1 ? 'moder' : ($me['access'] == 2 ? 'admim' : ($me['access'] == 3 ? 'Creator' : ($me['access'] == 4 ? 'Developer' : '' ) ) ))?></a>
                        <a href="/settings/avatar" class="menu-user-avatar" style="background-image: url(<?=$me['avatar']?>), linear-gradient(40deg,#2f3640,#d63031)!important;"></a>
                    </div>
                </div>
                <div class="menu-items mt-3">
                	<a href="/news" class="menu-item border-0"><i class="material-icons mr-2">receipt </i> Новости <span class="badge badge-pill badge-theme float-right" style="margin-top: 12px;"><?=Base::count('news', 'time > :time', ['time/int' => 0])?></span></a>
					<a href="/friends" class="menu-item border-0"><i class="material-icons mr-2">people </i> Друзья <span class="badge badge-pill badge-theme float-right" style="margin-top: 12px;"><?=$friends->countSubscribers($me['id'])?></span></a>
					<a href="/mail" class="menu-item border-0"><i class="material-icons mr-2">email</i> Сообщения <span class="badge badge-pill badge-theme float-right" style="margin-top: 12px;"><?=$mail->unreadDialogs()?></span></a>
                    <a href="/albums" class="menu-item border-0"><i class="material-icons mr-2">photo </i> Альбомы <span class="badge badge-pill badge-theme float-right" style="margin-top: 12px;"><?=Base::count('albums', 'user_id = :id', ['id' => $me['id']]) ?></span></a>
                    <a href="/settings" class="menu-item border-0"><i class="material-icons mr-2">settings</i> Настройки </a>
                    <a href="/exit" class="menu-item border-0"><i class="material-icons mr-2">logout</i> Выход</a>
                </div>
            <?php else: ?>
                <div class="menu-content">
                    <div class="menu-items text-center p-3">
                    <div class="menu-item-header mb-2 text-light">Авторизация</div>
                    <div id="alertsHeader" class="mb-2" style="margin-left: -10px; margin-right: -10px;"></div>
                    <script type="text/javascript">
                    	$(document).ready(function () {
                    		
                    		$('#okHeadButton').on('click', function(e) {
                    			e.preventDefault();
                    			var formDataHead = $('#authHeadForm').serialize();
                    			var alertsHeader = $('#alertsHeader');
                    			
                    			$.ajax({
                    			url: '/AJAX/login/authorization.php',
                    			type: 'POST',
                    			data: formDataHead,
                    			dataType: 'json',
                    			success: function(json) {
                    				
                    				if(json['error'] == 1) {
                    					$(alertsHeader).html('<div class="alert alert-danger">'+json['comment']+'</div>');
                    				} else if(json['success'] == 1) {
                    					$(alertsHeader).html('<div class="alert alert-success">'+json['comment']+'</div>');
                    				}
                    				setTimeout(function () {
                    					$(alertsHeader).html('');
                    					if(json['success'] == 1) {
                    						location.href = json['url'];
                    					}
                    				}, 1000);
                    			},
                    			error: function(xhr, ajaxOptions, thrownError) {
                    				alert(thrownError + "\r\n" + xhr.statusText + "\r\n " + xhr.responseText);
                    			}
                    			});
                    		});
                    	});
                    </script>
                    <form action="/AJAX/login/authorization.php" method="POST" id="authHeadForm">
                        <div class="form-group text-left">
                            <label class="form-check-label text-light">Логин и телефон</label>
                            <input type="text" class="form-control input-inset" name="login">
                        </div>
                        <div class="form-group text-left">
                            <label class="form-check-label text-light">Пароль</label>
                            <input type="password" class="form-control input-inset" name="password" placeholder="">
                        </div>
                        <div class="form-group">
                            <input type="submit" class="btn btn-md btn-theme btn-block" id="okHeadButton" value="Войти">
                        </div>
                    </form>
                    
                    <a href="/auth_vk" class="btn btn-md btn-theme-link btn-block d-none">Войти через Вконтакте</a>
                    <a href="/registration" class="btn btn-md btn-theme-link btn-block "> Регистрация</a>
                    <a href="/forgot" class="btn btn-md btn-theme-link btn-block">Забыли пароль? </a>
                </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

    <nav class="header navbar bg-theme">
        <div class="switch"  onclick="switchMenu()" onclick="switchMenu()">
            <svg viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"><path d="M0 0h24v24H0V0z" fill="none" /><path d="M4 18h16c.55 0 1-.45 1-1s-.45-1-1-1H4c-.55 0-1 .45-1 1s.45 1 1 1zm0-5h16c.55 0 1-.45 1-1s-.45-1-1-1H4c-.55 0-1 .45-1 1s.45 1 1 1zM3 7c0 .55.45 1 1 1h16c.55 0 1-.45 1-1s-.45-1-1-1H4c-.55 0-1 .45-1 1z" fill="#ffffff" /></svg>
        </div>
        <a href="/" class="navbar-brand text-light mr-auto"><?=(empty($titleHeader) ? $_SERVER['HTTP_HOST'] : $titleHeader)?></a>
        <div class="nav-right-menu pb-2 pr-2">
            <?php if(isset($me)): ?>
                <a href="/notifications" class=""><i class="material-icons text-light md-24 mr-2">notifications</i></a>
                <a href="/mail" class=""><i class="material-icons text-light md-24 mr-2">email</i></a>
                <a href="#profile" class="header-avatar" style="background-image: url(<?=$me['avatar']?>);" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"></a>

                <div class="dropdown-menu dropdown-menu-right">
                    <a class="dropdown-item" href="/id<?=$me['id']?>">@<?=$me['login']?> <span class="badge badge-info badge-pill float-right"><?=$me['money']?> ₽</span></a>
                    <a class="dropdown-item" href="/albums">Альбомы</a>
                    <a class="dropdown-item" href="/settings">Настройки</a>
                    <?php if($me['access'] > 0): ?>
                        <a class="dropdown-item" href="/admin">Панель управления</a>
                    <?php endif; ?>
                    <div class="dropdown-divider"></div>
                    <a class="dropdown-item" href="/exit">Выйти</a>
                </div>
            <?php endif; ?>
        </div> 
    </nav>

    <div class="container-fluid w-100" id="content">
        <div class="row ">