<?php
require_once($_SERVER['DOCUMENT_ROOT'].'/system/App.php');


if(isset($_POST) && $_SERVER['REQUEST_METHOD'] == 'POST')
{
	$name = isset($_POST['name']) && !empty($_POST['name']) ? $sys->protect($_POST['name']) : null;
	$type = isset($_POST['type']) && !empty($_POST['type']) ? intval($_POST['type']) : 0; 
	
    if(empty($name))
	{
		$json = ['error' => 1, 'comment' => 'Введите название категории'];
	}
    else if($me['access'] < 3 && $type == 2)
	{
		$json = ['error' => 1, 'comment' => 'У вас недостаточно прав, <b>VIP</b> категорию можно создать с уровня создатель'];
	}
    else if($me['access'] < 2 && $type == 1)
	{
		$json = ['error' => 1, 'comment' => 'У вас недостаточно прав, <b>платную</b> категорию можно создать с уровня администратор и выше'];
	}
	else
	{
	    $checkName = Base::get('category_gifts', ['name' => $name]);
	    if(!empty($checkName))
	    {
        	$json = ['error' => 1, 'comment' => 'Такая категория уже существует'];
	    }
	    else
	    {
	        $categoryID = $gifts->addCat($name, $type);
	        
	        if($categoryID)
	        {
                $json = ['success' => 1, 'comment' => 'Категория успешно создана', 'url' => HOME.'/admin/gifts/cat'.$categoryID];
	        }
	        else
	        {
	            $json = ['error' => 1, 'comment' => 'Категория не была создана'];
	        }
	    }
	}
}
else
{
	$json = ['error' => 1, 'comment' => 'Пустое значение'];
}

echo json_encode($json, JSON_UNESCAPED_UNICODE);
?>