<?php
require_once($_SERVER['DOCUMENT_ROOT'].'/system/App.php');
	
if(isset($_SERVER['HTTP_X_REQUESTED_WITH']) && !empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest' && $_SERVER['REQUEST_METHOD'] == 'POST')
{
	$albumName = isset($_POST['name']) && !empty($_POST['name']) ? $sys->protect($_POST['name']) : null;
	$formId = isset($_POST['form_id']) && !empty($_POST['form_id']) ? intval($_POST['form_id']) : null;
	
	if (empty($albumName))
	{
		$json = [
			'error' => 1,
			'comment' => 'Вы не ввели название альбома',
		];
	}
	elseif (empty($formId))
	{
		$json = [
			'error' => 1,
			'comment' => 'Не указан id формы, обновите страницу',
		];
	}
	else
	{
		$files = $_FILES;
		$countFiles = count($files);
		
		if (empty($countFiles))
		{
			$json = [
				'error' => 1,
				'comment' => 'Изображения не выбраны',
			];
		}
		elseif ($countFiles > $settings->max_files_to_download)
		{
			$json = [
				'error' => 1,
				'comment' => 'Лимит на разовую загрузку - '.$settings->max_files_to_download,
			];
		}
		else
		{
			$maxSize = 10;
			$uploadDir = ROOT.'/uploads/'; 
			
			$arrTypes = [
				'gif',
				'jpg',
				'png',
				'jpeg', 
				'bmp',
			];
			
			$albumId = Base::add('albums', [
				'time' => TIME, 
				'name' => $albumName,
				'user_id' => $me['id'], 
			]);
			
			if (!empty($albumId))
			{
				
				foreach($files as $file)
				{
					$name = $file['name'];
					$uploadType = substr($name, strrpos($name, ".") + 1);
					
					$newName = $_SERVER['HTTP_HOST'].'-'.$core->hash(10).'.'.$uploadType;
					
					if (!file_exists($file['tmp_name']))
					{
						$json = [
							'error' => 1,
							'comment' => 'Изображения не выбраны',
						];
					}
					elseif ($file['size'] > (1048576 * $maxSize))
					{
						$json = [
							'error' => 1,
							'comment' => 'Вес изображения не должен превышать '.$maxSize.' мб',
						];
					}
					elseif (!in_array($uploadType, $arrTypes))
	        		{
						$json = [
							'error' => 1, 
							'comment' => 'Файл данного формата выгружать запрещено',
						];
	        		}
	        		else
	        		{
	        			
	        			if (move_uploaded_file($file['tmp_name'], $uploadDir.$newName) && Base::add('photos', ['name' => $newName, 'user_id' => $me['id'], 'album_id' => $albumId]))
	        			{
							$json = [
								'success' => 1,
								'comment' => 'Альбом успешно создан',
								'url' => HOME.'/album/id'.$albumId,
							];
	        			}
	        			else
	        			{
	        				$json = [
								'error' => 1,
								'comment' => 'Ошибка загрузки изображения',
							];
	        			}
	        		}
				}
			}
			else
			{
				$json = [
					'error' => 1,
					'comment' => 'Альбом не был создан',
				];
			}
		}
	}
	
}
else
{
	$json = ['error' => 1, 'comment' => '404 Bad Request'];
}
echo json_encode($json, JSON_UNESCAPED_UNICODE);
