<?php
require_once($_SERVER['DOCUMENT_ROOT'].'/system/App.php');
	
if ($sys->isAjax())
{
	$user_id = isset($_POST['id']) && !empty($_POST['id']) ? (int) $_POST['id'] : false;
	
	$checkUser = $user->InfoById($user_id, 'id');
	
	if (!$checkUser)
	{
		$json = [
			'error' => 1, 
			'comment' => 'Пользователь не найден',
		];
	}
	elseif (!$me)
	{
		$json = [
			'error' => 1, 
			'comment' => 'Авторизируйтесь для выполнения этого действия',
		];
	}
	elseif ($me['id'] == $user_id)
	{
		$json = [
			'error' => 1, 
			'comment' => 'Нельзя удалить самого себя'
		];
	}
	elseif (!$friends->isFriends($me['id'], $user_id))
	{
		$json = [
			'error' => 1, 
			'comment' => 'Вы не друзья',
		];
	}
	else
	{
		if ($friends->remove($me['id'], $user_id))
		{
			$json = [
				'success' => 1, 
				'comment' => 'Пользователь удален из друзей',
			];
		}
		else
		{
			$json = [
				'error' => 1, 
				'comment' => 'Пользователь не был удален из друзей',
			];
		}
	}
}
else
{
	$json = [
		'error' => 1, 
		'comment' => '404 Bad Request'
	];
}
echo json_encode($json, JSON_UNESCAPED_UNICODE);
