<?php
require_once($_SERVER['DOCUMENT_ROOT'].'/system/App.php');

if($sys->isAjax() && $_SERVER['REQUEST_METHOD'] == 'POST')
{
	$stage = isset($_GET['stage']) && !empty($_GET['stage']) ? intval($_GET['stage']) : 1;
	
	if ($stage == 1)
	{
		$login = isset($_POST['login']) && !empty($_POST['login']) ? $sys->protect($_POST['login']) : null;
		
		if (empty($login))
		{
			$json = [
				'error' => 1,
				'comment' => 'Вы не ввели логин/телефон'
			];
		}
		elseif (!preg_match('|^[a-zA-Z0-9_-]+$|i', $login))
		{
			$json = [
				'error' => 1,
				'comment' => 'Не корректный логин/телефон'
			];
		}
		else
		{
			$checkUser = Base::get('user', 'login = :login or number = :number', [
				'login' => $login,
				'number' => $login
			]);
			
			if (!$checkUser)
			{
				$json = [
					'error' => 1,
					'comment' => 'Пользователь с таким логином/телефоном не найден'
				];
			}
			else
			{
				$pincode = random_int(000000, 99999999);
				
				Base::add('forgot', [
					'time' => TIME,
					'user_id' => $checkUser['id'],
					'pincode' => $pincode,
					'hash' => md5($checkUser['id'].$pincode)
				]);
				
				$sendForgotResponse = $aero->send("Пин-код: ".$pincode."\r\n".$_SERVER['HTTP_HOST'], $checkUser['number']);
				
				if (!empty($sendForgotResponse) && $sendForgotResponse->success == true)
				{
					$json = [
						'success' => 1,
						'comment' => 'Пин-код отправлен, введите его в форме ниже',
						'hash' => md5($checkUser['id'].$pincode)
					];
				}
				else
				{
					$core->setLog($sendForgotResponse);
					
					$json = [
						'error' => 1,
						'comment' => "Смс не отправилось на ваш номер!<br> Возможные причины: <br>1) Вы не верно указали номер.<br>2) Ваш номер занесен в черный список. <br>3) Технические причины. <br>Пожалуйста, обратитесь в службу поддержки!"
					];
				}
			}
		}
	}
	elseif ($stage == 2)
	{
		$hash = isset($_POST['hash']) && !empty($_POST['hash']) ? $sys->protect($_POST['hash']) : null;
		$pincode = isset($_POST['pincode']) && !empty($_POST['pincode']) ? $sys->protect($_POST['pincode']) : null;
		$newPassword = isset($_POST['password']) && !empty(trim($_POST['password'])) ? $sys->protect($_POST['password']) : null;
		
		if (empty($hash))
		{
			$json = [
				'error' => 1,
				'comment' => 'Хеш не указан'
			];
		}
		elseif (empty($pincode))
		{
			$json = [
				'error' => 1,
				'comment' => 'Введите пин-код',
			];
		}
		elseif (empty($newPassword))
		{
			$json = [
				'error' => 1,
				'comment' => 'Введите пароль',
			];
		}
		else
		{
			$checkHash = Base::get('forgot', 'recovered <> 1 AND hash = :hash', [
				'hash' => $hash,
			]);
			
			if (!$checkHash)
			{
				$json = [
					'error' => 1,
					'comment' => 'Сессия истекла, попробуйте еще раз',
				];
			}
			else
			{
				
				if ($checkHash['pincode'] != $pincode)
				{
					$json = [
						'error' => 1,
						'comment' => 'Пин-код не верный, либо время действия истекло',
					];
				}
				else
				{
					Base::update('user', $checkHash['user_id'], [
						'password' => $newPassword
					]);
					
					Base::update('forgot', $checkHash['id'], [
						'recovered' => 1,
					]);
					
					$json = [
						'success' => 1,
						'comment' => 'Пароль успешно сменен',
					];
				}
			}
		}
	}
}
else
{
	$json = ['error' => 1, 'comment' => '404 Bad Request'];
}
echo json_encode($json, JSON_UNESCAPED_UNICODE);
