<?php
require_once('../system/App.php');

if($sys->isAjax())
{
	$chatName = isset($_GET['chat_name']) && !empty($_GET['chat_name']) ? $sys->protect($_GET['chat_name']) : null;
	$chatAvatar =  isset($_GET['chat_avatar']) && !empty($_GET['chat_avatar']) ? $sys->protect($_GET['chat_avatar']) : null;
	$chatUsers =  isset($_GET['user_id']) && !empty($_GET['user_id']) ? $_GET['user_id'] : null;
	
	if(empty($chatName))
	{
		$json = ['error' => 1, 'comment' => 'Введите название беседы'];
	}
	else if(empty($chatAvatar))
	{
		$json = ['error' => 1, 'comment' => 'Установите аватар беседы'];
	}
	else if(empty($chatUsers) || count($chatUsers) < 1)
	{
		$json = ['error' => 1, 'comment' => 'Выберите хотя бы одного собеседника'];
	}
	else
	{
		$chat = $mail->createChat($chatName, $chatAvatar, $chatUsers);
		if(!empty($chat))
		{
			$json = ['success' => 1, 'comment' => 'Беседа успешно создана', 'url' => HOME.'/mail/id'.$chat];
		}
		else
		{
			$json = ['error' => 1, 'comment' => 'Неизвестная ошибка, чат не был создан'];
		}
	}
}
else
{
	$json = ['error' => 1, 'comment' => 'Пустое значение'];
}
echo json_encode($json, JSON_UNESCAPED_UNICODE);
