<?php
require_once($_SERVER['DOCUMENT_ROOT'].'/system/App.php');
	
if ($sys->isAjax())
{
	$age = isset($_POST['age']) && !empty($_POST['age']) ? (int) $_POST['age'] : false;
	$city = isset($_POST['city']) && !empty($_POST['city']) ? $sys->protect($_POST['city']) : null;
	$login = isset($_POST['login']) && !empty($_POST['login']) ? $sys->protect($_POST['login']) : null;
	$email = isset($_POST['email']) && !empty($_POST['email']) ? $sys->protect($_POST['email']) : null;
	$name = isset($_POST['name']) && !empty($_POST['name']) ? $sys->protect($_POST['name']) : null;
	$country = isset($_POST['country']) && !empty($_POST['country']) ? $sys->protect($_POST['country']) : null;
	$lastName = isset($_POST['last_name']) && !empty($_POST['last_name']) ? $sys->protect($_POST['last_name']) : null;
	
	if (!$me)
	{
		$json = [
			'error' => 1, 
			'comment' => 'Авторизируйтесь для выполнения этого действия',
		];
	}
	elseif (!preg_match('/^(\d+){2}$/', $age))
	{
		$json = [
			'error' => 1, 
			'comment' => 'Введите корректный возраст',
		];
	}
	elseif (!preg_match('/^(([a-z0-9]|[а-яё]){3,25})$/iu', $city))
	{
		$json = [
			'error' => 1, 
			'comment' => 'Введите корректный город',
		];
	}
	elseif (!preg_match('/^(\w+){3,20}$/', $login))
	{
		$json = [
			'error' => 1, 
			'comment' => 'Введите корректный логин',
		];
	}
	elseif (!preg_match('/^(([a-z]|[а-яё]){3,25})$/iu', $city))
	{
		$json = [
			'error' => 1, 
			'comment' => 'Введите корректное имя',
		];
	}
	elseif (!preg_match('/^(([a-z]|[а-яё]){3,25})$/iu', $city))
	{
		$json = [
			'error' => 1, 
			'comment' => 'Введите корректную страну проживания',
		];
	}
	elseif (!preg_match('/^(([a-z0-9]|[а-яё]){3,25})$/iu', $city))
	{
		$json = [
			'error' => 1, 
			'comment' => 'Введите корректную фамилию',
		];
	}
	else
	{
		$query = Base::update('user', $me['id'], [
			'age/int' => $age,
			'city' => $city,
			'login' => $login,
			'email' => $email,
			'name' => $name,
			'country' => $country,
			'last_name' => $lastName,
		]);
		
		if ($query)
		{
			$json = [
				'success' => 1, 
				'comment' => 'Информация успешно отредактирована',
			];
		}
		else
		{
			$json = [
				'error' => 1, 
				'comment' => 'Информация не была отредактирована',
			];
		}
	}
}
else
{
	$json = [
		'error' => 1, 
		'comment' => '404 Bad Request'
	];
}
echo json_encode($json, JSON_UNESCAPED_UNICODE);
