<?php
require_once $_SERVER['DOCUMENT_ROOT'].'/system/App.php';

if(isset($_POST) && $_SERVER['REQUEST_METHOD'] == 'POST')
{
    $id = (!empty($_POST['album_id']) ? intval($_POST['album_id']) : null);
    $album = $albums->getByID($id);
    
    if(empty($album))
    {
        $json = array('error' => '1', 'comment' => 'Альбом не найден');
    }
    else
    {
        $uploaddir = '../uploads/'; 
    	if(!is_dir( $uploaddir)) mkdir( $uploaddir, 0777 );
    	
        $max = 5;
    	$files = $_FILES;
    	$type = array('jpg','gif','png','jpeg', 'bmp');
    	
    	foreach($files as $value)
    	{
    		$name = $value['name'];
    		$new_name = preg_replace('/[^A-zА-яёЁ0-9\.]+/u', '', $name);
    		
        	$uptype = substr($name, strrpos($name, ".") + 1);
        	
        	if(!file_exists($value['tmp_name']))
        	{
        		$json = array('error' => '1', 'comment' => 'Выберите файл');
        	}
        	elseif($value['size'] > (1048576 * $max))
        	{
        		$json = array('error' => '1', 'comment' => 'Вес файла должен быть не более '.$max.' мб');
        	}
        	elseif(!in_array($uptype, $type))
        	{
        		$json = array('error' => '1', 'comment' => 'Файл данного формата выгружать запрещено');
        	}
        	else
        	{
                if(@move_uploaded_file($value['tmp_name'], $uploaddir.$new_name))
    		    {
        			if(Base::add('photos', ['name' => $new_name, 'user_id' => $me['id'], 'album_id' => $album['id']]))
        			{
        				$json = array('success' => '1', 'comment' => 'Изображение успешно загружено');
        			}
        			else
        			{
        				$json = array('error' => '1', 'comment' => 'Ошибка записи изображения в базу данных');
        			}
    		    }
    		    else
        		{
        			$json = array('error' => '1', 'comment' => 'Ошибка загрузки изображения');
        		}
        	}
        }
    }
}
else
{
	$json = array('error' => '1', 'comment' => 'Пустое значение');
}

echo json_encode($json, JSON_UNESCAPED_UNICODE);
?>