<?php
require_once($_SERVER['DOCUMENT_ROOT'].'/system/App.php');
	
if ($sys->isAjax())
{
	$query = isset($_POST['query']) && !empty($_POST['query']) ? $sys->protect($_POST['query']) : null;
	
	$params = [
		'sort' => (isset($_POST['sort']) && !empty($_POST['sort']) ? (int) $_POST['sort'] : 0),
		'order' => (isset($_POST['order']) && !empty($_POST['order']) ? (int) $_POST['order'] : 0),
		'count' => (isset($_POST['count']) && !empty($_POST['count']) ? (int) $_POST['count'] : 10),
		'fields' => (isset($_POST['offset']) && !empty($_POST['offset']) ? (int) $_POST['offset'] : 0),
		'photo_only' => (isset($_POST['photo_only']) && !empty($_POST['photo_only']) ? 1 : 0),
		'online_only' => (isset($_POST['online_only']) && !empty($_POST['online_only']) ? 1 : 0),
	];
	
	if (empty($query))
	{
		$json = [
			'error' => 1, 
			'comment' => 'Введите текст',
		];
	}
	else
	{
		$arrSearchUsers = $users->search($query, $params);
		
		if (!empty($arrSearchUsers) && is_array($arrSearchUsers))
		{
			$json = [
				'success' => 1, 
				'response' => $arrSearchUsers,
			];
		}
		else
		{
			$json = [
				'error' => 1, 
				'comment' => 'Ничего не найдено',
			];
		}
	}
}
else
{
	$json = [
		'error' => 1, 
		'comment' => '404 Bad Request'
	];
}
echo json_encode($json, JSON_UNESCAPED_UNICODE);
