<?php
require_once($_SERVER['DOCUMENT_ROOT'].'/system/App.php');
$title = 'Подарки';
require_once ROOT.'/system/header.php';
?>
	
<div class="col-sm col-md col-lg-3 d-xs-none">
    <div class="card">
	    <ul class="list-group list-group-flush">
	        <li class="list-group-item"><i class="material-icons md-20" style="top: 4px!important;">list</i> Меню</li>
	        <a href="/admin/users" class="list-group-item"><i class="material-icons md-20" style="top: 4px!important;">supervised_user_circle</i> Пользователи</a>
	        <a href="/admin/albums" class="list-group-item"><i class="material-icons md-20" style="top: 4px!important;">photo_album</i> Альбомы</a>
	        <a href="/admin/gifts" class="list-group-item"><i class="material-icons md-20" style="top: 4px!important;">card_giftcard</i> Подарки</a>
	    </ul>
	</div>
</div>

<div class="col-md col-lg-6">
	
	<nav aria-label="breadcrumb">
		<ol class="breadcrumb">
			<div class="b-item">
				<li class="breadcrumb-item">
					<a href="/admin"><i class="material-icons md-18" style="top: 4px!important;">tune</i> Панель управления</a>
				</li>
				<li class="breadcrumb-item active" aria-current="page"><i class="material-icons md-18" style="top: 4px!important;">card_giftcard</i> <?=$title?></li>
			</div>
		</ol>
	</nav>

    <div class="mb-3">
		<button type="button" class="btn btn-theme-active btn-block" data-toggle="modal" data-target="#exampleModalCenter">Добавить категорию</button>
	</div>
	
	<div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered" role="document">
			<div class="modal-content bg-theme-dark">
				<div class="modal-header" style="border-bottom: 1px solid rgba(0,0,0,0.2)!important;">
					<h5 class="modal-title text-muted" id="exampleModalLongTitle">Добавить категорию</h5>
					<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
				</div>
				<div class="modal-body">
					<script type="text/javascript">
			        $(document).ready(function () {
			        	
			        	$('#okButton').on('click', function(e) {
			        		e.preventDefault();
			        		var formData = $('#addCatForm').serialize();
			        		var alerts = $('#modalAlert');
			        		
			        		$.ajax({
			        		url: $('#addCatForm').attr('action'),
			        		type: $('#addCatForm').attr('method'),
			        		data: formData,
			        		dataType: 'json',
			        		success: function(json) {
			
			        			if(json['error'] == 1) {
			        				$(alerts).html('<div class="alert alert-danger">'+json['comment']+'</div>');
			        			} else if(json['success'] == 1) {
			        				location.href = json['url'];
			        			}
			        			setTimeout(function () {
			        				$(alerts).html('');
			        			}, 2000);
			        		},
			        		error: function(xhr, ajaxOptions, thrownError) {
			        			alert(thrownError + "\r\n" + xhr.statusText + "\r\n " + xhr.responseText);
			        		}
			        		});
			        	});
			        });
			        </script>
					<form action="/AJAX/admin/addGiftCategory.php" method="POST" id="addCatForm">
						<div id="modalAlert"></div>
						<div class="form-group">
							<label for="inputCatName">Название категории</label>
							<input type="text" name="name" class="form-control" id="inputCatName" value="">
						</div>
						<div class="form-group">
							<label for="controlTypeCat">Тип категории</label>
                            <select class="form-control" id="controlTypeCat" name="type">
                                <option value="2">VIP</option>
                                <option value="1">Платные</option>
                                <option value="0">Бесплатные</option>
                            </select>
                        </div>
					</form>
				</div>
				<div class="modal-footer" style="border-top: 1px solid rgba(0,0,0,0.2)!important;">
					<button type="button" class="btn btn-danger" data-dismiss="modal">Отмена</button>
					<button type="button" class="btn btn-success" id="okButton">Добавить</button>
				</div>
			</div>
		</div>
	</div>
	<div id="alerts"></div>
	<div class="card">
    	<ul class="list-group list-group-flush">
    	    <?php
    	    $categories = $gifts->getCats(0, 20);
    	    
    	    if(!empty($categories))
    	    {
    	        foreach($categories as $cat)
    	        {
    	            ?>
    	            <li class="list-group-item" id="cat<?=$cat['id']?>">
	                    <a href="/admin/gifts/cat<?=$cat['id']?>" class="text-secondary">
    	                    <i class="material-icons md-20" style="top: 4px!important;">list</i>
    	                    <?=$cat['name']?>
                        </a>
                        <span class="float-right"><a href="#deleteCat" class="delete-cat" data-id="<?=$cat['id']?>"><i class="material-icons md-20 text-danger" style="top: 4px!important;">delete</i></a>   <a href="#editCat" class="edit-cat" data-id="<?=$cat['id']?>"><i class="material-icons md-20 text-secondary" style="top: 4px!important;">edit</i></a> </span>
                    </li>
    	            <?php
    	        }
    	    }
    	    else
    	    {
    	        ?>
    	        <li class="list-group-item text-center text-secondary">Пока пусто...</li>
    	        <?php
    	    }
    	    ?>
	    </ul>
		<script type="text/javascript">
        $(document).ready(function () {
        	
        	$('.delete-cat').on('click', function(e) {
        		e.preventDefault();
        		var data = $(this).attr('data-id');
        		var al = $('#alerts');
        		console.log('click');
        		$.ajax({
        		url: '/AJAX/admin/removeGiftCategory.php',
        		type: 'POST',
        		data: {id:data},
        		dataType: 'json',
        		success: function(json) {

        			if(json['error'] == 1) {
        				$(al).html('<div class="alert alert-danger">'+json['comment']+'</div>');
        				console.log('error: ' + json['comment']);
        			} else if(json['success'] == 1) {
        				$('#cat' + data).remove();
        			}
        			setTimeout(function () {
        				$(al).html('');
        			}, 2000);
        		},
        		error: function(xhr, ajaxOptions, thrownError) {
        			alert(thrownError + "\r\n" + xhr.statusText + "\r\n " + xhr.responseText);
        			console.log('error: ' + xhr.responseText);
        		}
        		});
        	});
        });
        </script>
    </div>
</div>
<div class="col-lg-3"></div>
<?php
require_once ROOT.'/system/footer.php';
?>