<?php
require_once($_SERVER['DOCUMENT_ROOT'].'/system/App.php');
$giftCat = $gifts->getCatByID($id);
$title = !empty($giftCat['name']) ? $giftCat['name'] : 'Категория';
require_once ROOT.'/system/header.php';
if(empty($giftCat)) $core->redirect('/admin/gifts');
?>

	
<div class="col-sm col-md col-lg-3 d-xs-none">
    <div class="card">
	    <ul class="list-group list-group-flush">
	        <li class="list-group-item"><i class="material-icons md-20" style="top: 4px!important;">list</i> Меню</li>
	        <a href="/admin/users" class="list-group-item"><i class="material-icons md-20" style="top: 4px!important;">supervised_user_circle</i> Пользователи</a>
	        <a href="/admin/albums" class="list-group-item"><i class="material-icons md-20" style="top: 4px!important;">photo_album</i> Альбомы</a>
	        <a href="/admin/gifts" class="list-group-item"><i class="material-icons md-20" style="top: 4px!important;">card_giftcard</i> Подарки</a>
	    </ul>
	</div>
</div>

<div class="col-md col-lg-6">
	<nav aria-label="breadcrumb">
		<ol class="breadcrumb">
			<div class="b-item">
				<li class="breadcrumb-item">
					<a href="/admin/gifts"><i class="material-icons md-18" style="top: 4px!important;">card_giftcard</i> Подарки</a>
				</li>
				<li class="breadcrumb-item active" aria-current="page"><i class="material-icons md-18" style="top: 4px!important;">link</i> <?=$title?></li>
			</div>
		</ol>
	</nav>
	

    <div class="mb-3">
		<button type="button" class="btn btn-theme-active btn-block" data-toggle="modal" data-target="#exampleModalCenter">Добавить подарок</button>
	</div>
	
	<div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered" role="document">
			<div class="modal-content bg-theme-dark">
				<div class="modal-header" style="border-bottom: 1px solid rgba(0,0,0,0.2)!important;">
					<h5 class="modal-title text-muted" id="exampleModalLongTitle">Добавить подарок</h5>
					<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
				</div>
				<div class="modal-body">
					<script type="text/javascript">
			        $(document).ready(function () {
    					var progressBar = $('#progressbar');
                        var alerts = $('#modalAlert');
                        var files;
        				$('input[type=file]').on('change', function(){
        				    files = this.files;
        				});
				
				        $('#okButton').on('click', function(e){
    				        e.preventDefault();
    				        var $that = $('#addGiftForm');
    				        if(typeof files != 'undefined') progressBar.show();
  						
    				        var data = new FormData();
    				
            				$.each(files, function(key, value) {
            				data.append(key, value);
            				});
            				data.append('cat_id', '<?=$giftCat['id']?>');
                        	data.append('name', $('#inputGiftName').val()); 
                        	data.append('price', $('#inputGiftPrice').val()); 
            				$.ajax({
                				url: $that.attr('action'),
                				type: $that.attr('method'),
                				contentType: false,
                				processData: false,
                				data: data,
                				dataType: 'json',
                				xhr: function() {
                    				var xhr = $.ajaxSettings.xhr();
                    				xhr.upload.addEventListener('progress', function(evt){
                        				if(evt.lengthComputable) {
                        				    var percentComplete = Math.ceil(evt.loaded / evt.total * 100);
                        				    progressBar.html('<div class="progress-bar progress-bar-striped progress-bar-animated bg-success" style="width: ' + percentComplete + '%"></div>');
                        				}
                				    }, false);
                				    return xhr;
                				},
                				success: function(json){
                				    progressBar.hide()
                				
                    				if(json['error'] == 1) {
                    				    if(!isEmpty(json['comment']))
                    				    {
                    					    alerts.html('<div class="alert alert-danger">'+json['comment']+'</div>');
                    				    }
                    				} else if(json['success'] == 1) {
                    				    if(!isEmpty(json['comment']))
                    				    {
                    					    alerts.html('<div class="alert alert-success">'+json['comment']+'</div>');
                    				    }
                    				}
                    				setTimeout(function () {
                    				    alerts.html('');
                    				}, 2000);
                				},
                				error: function(xhr, ajaxOptions, thrownError) {
                					alert(thrownError + "\r\n" + xhr.statusText + "\r\n " + xhr.responseText);
                				}
            				});
				        });
			        });
			        </script>
					<form action="/AJAX/admin/uploadGiftFromCategory.php" method="POST" id="addGiftForm">
						<div id="modalAlert"></div>
						<div class="form-group">
							<label for="inputCatName">Название подарка</label>
							<input type="text" name="name" class="form-control" id="inputGiftName" value="">
						</div>
						<div class="form-group">
						    <label for="inputCatName">Цена подарка</label>
                            <div class="input-group mb-3">
                              <div class="input-group-prepend">
                                <span class="input-group-text">₽</span>
                              </div>
                              <input type="text" name="price" id="inputGiftPrice" class="form-control" aria-label="Amount (to the nearest dollar)">
                            </div>
						</div>
						<div class="progress mb-3" id="progressbar" style="display: none;"></div>
						
						<div class="form_upload mb-3 w-100 text-center">
			    			<input type="file" name="my_file[]" id="my_file" multiple/>
                            <span class="btn btn-theme-active">Загрузить изображение</span>
						</div>
					</form>
				</div>
				<div class="modal-footer" style="border-top: 1px solid rgba(0,0,0,0.2)!important;">
					<button type="button" class="btn btn-danger" data-dismiss="modal">Отмена</button>
					<button type="button" class="btn btn-success" id="okButton">Добавить</button>
				</div>
			</div>
		</div>
	</div>
	

	<div class="card">
    	<ul class="list-group list-group-flush">
    	    <?php
    	    $giftsList = $gifts->getGiftsByID($giftCat['id']);
    	    
    	    if(!empty($giftsList))
    	    {
    	        foreach($giftsList as $list)
    	        {
    	            ?>
    	            <li class="list-group-item" id="gift<?=$list['id']?>">
	                    <a href="/admin/gifts/cat<?=$list['id']?>" class="text-secondary">
    	                    <img src="<?=$list['image']?>" style="width: 40px; height: 40px;">
    	                    <?=$list['name']?>
                        </a>
                        <span class="float-right">
                            <a href="#deleteGift" class="delete-gift" data-id="<?=$list['id']?>">
                                <i class="material-icons md-20 text-danger" style="top: 4px!important;">delete</i>
                            </a>   
                            <a href="#editGift"  data-toggle="modal" data-target="#editGiftModal" data-id="<?=$list['id']?>" data-name="<?=$list['name']?>" data-price="<?=$list['price']?>">
                                <i class="material-icons md-20 text-secondary" style="top: 4px!important;">edit</i>
                            </a> 
                        </span>
                    </li>
    	            <?php
    	        }
    	        ?>
    	        <script type="text/javascript">
                $(document).ready(function () {
                	
                	$('.delete-gift').on('click', function(e) {
                		e.preventDefault();
                		var data = $(this).attr('data-id');
                		var al = $('#alerts');
                		
                		$.ajax({
                		url: '/AJAX/admin/removeGift.php',
                		type: 'POST',
                		data: {id:data},
                		dataType: 'json',
                		success: function(json) {
        
                			if(json['error'] == 1) {
                				$(al).html('<div class="alert alert-danger">'+json['comment']+'</div>');
                			} else if(json['success'] == 1) {
                			    $('#gift' + data).remove();
                			}
                			setTimeout(function () {
                				$(al).html('');
                			}, 2000);
                		},
                		error: function(xhr, ajaxOptions, thrownError) {
                			alert(thrownError + "\r\n" + xhr.statusText + "\r\n " + xhr.responseText);
                			console.log('error: ' + xhr.responseText);
                		}
                		});
                	});
                });
                </script>
    	        <?php
    	    }
    	    else
    	    {
    	        ?>
    	        <li class="list-group-item text-center">Пока пусто...</li>
    	        <?php
    	    }
    	    ?>
	    </ul>
    </div>
    
    <div class="modal fade" id="editGiftModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content bg-theme-dark">
                <div class="modal-header" style="border-bottom: 1px solid rgba(0,0,0,0.2)!important;">
                    <h5 class="modal-title" id="exampleModalLabel">Редактировать подарок</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form action="/AJAX/editGift.php" method="POST" id="editGiftForm">
                        <div class="form-group">
                            <label for="recipient-name" class="col-form-label">Название:</label>
                            <input type="text" class="form-control" id="recipient-name">
                        </div>
						<div class="form-group">
						    <label for="inputCatName">Цена </label>
                            <div class="input-group mb-3">
                                <div class="input-group-prepend">
                                    <span class="input-group-text">₽</span>
                                </div>
                                <input type="text" name="price" id="recipient-price" class="form-control" aria-label="Amount (to the nearest dollar)">
                            </div>
						</div>
                    </form>
                </div>
                <div class="modal-footer" style="border-top: 1px solid rgba(0,0,0,0.2)!important;">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Отмена</button>
                    <button type="button" class="btn btn-theme-active" id="okEditGiftButton">Редактировать</button>
                </div>
            </div>
        </div>
    </div>
    <script>
    $('#editGiftModal').on('show.bs.modal', function (event) {
        var button = $(event.relatedTarget) // Button that triggered the modal
        var id = button.data('id')
        var name = button.data('name')
        var price = button.data('price') // Extract info from data-* attributes
        var modal = $(this)
        modal.find('#recipient-id').val(id)
        modal.find('#recipient-name').val(name)
        modal.find('#recipient-price').val(price)
    })
    </script>
</div>
<div class="col-lg-3"></div>
<?php
require_once ROOT.'/system/footer.php';
?>