<?php
require_once $_SERVER['DOCUMENT_ROOT'].'/system/App.php';

$id = isset($_GET['id']) && !empty($_GET['id']) ? (int) $_GET['id'] : null;
$userInfo = !empty($id) ? $user->infoById($id, 'name') : null;

$titleHeader = 'Аудиозаписи';
$title = $titleHeader.(!empty($userInfo) ? ' - '.$userInfo['name'] : null);

require_once ROOT.'/system/header.php';
$user->access();

// if (!$userInfo && $_SERVER['REQUEST_URI'] != '/audios' || $id == $me['id']) header('Location: /audios');
?>
	<script src="<?=HOME?>/design/js/playerjs.js" type="text/javascript"></script>
<div class="col-lg-4"></div>
<div class="col-sm-8 col-md-6 col-lg-4">
	
	<nav aria-label="breadcrumb">
		<ol class="breadcrumb">
			<div class="b-item">
				<li class="breadcrumb-item">
					<a href="/">На главную</a>
				</li>
				<li class="breadcrumb-item active" aria-current="page"><?=$titleHeader?></li>
				<?php if(!empty($userInfo)): ?>
					<li class="breadcrumb-item active" aria-current="page">
						<a href="/id<?=$id?>">
							<?=$userInfo['name']?>
						</a>
					</li>
				<?php endif; ?>
			</div>
		</ol>
	</nav>
	
	<style>
	.audio-poster {
		background-position: center;
		background-size: cover;
		background-repeat: no-repeat;
		width: 100%;
		height: 90px;
		border-radius: 5px 0 0 5px;
		color: white;
		text-align: center;
		padding: 15px;
	}
	.audio-track {
		background-color: #373a42;
		box-shadow: 0 2px 6px rgba(0,0,0,.2);
		border-radius: 5px;
		height: 90px;
		margin-bottom: 10px;
		list-style-type: none; 
	}
	</style>
	
	<script>
	$(document).ready(function() {
		var alerts = $('#alerts');
		var response = $('#response');
		
		var offset = 0;
		var limit = 10;
		
		function getMyPL() {
			var indexx = 0;
			$.ajax({
				url: '/AJAX/audios/getMyPlayList.php',
				type: 'POST',
				dataType: 'json',
				beforeSend: function() {
					
				},
				success: function(json) {
					$('#playlist-json').attr('data-json', JSON.stringify(json.response));
					
					// alert ($('#playlist-json').attr('data-json'));
					
					// json = $.parseJSON(json);
					if (json.success == 1)
					{
						response.html('<div class="mb-3"><ul class="p-0 m-0" id="audio-list"></ul></div>');
						
						json['response'].forEach(function(audio) {
							
							var body = '<li class="audio-track track-id' + audio.id + '" data-src="' + audio.url + '"><div class="form-row">';
							var poster = '<div class="col-4"><div class="audio-poster justify-content-center" style="background-image: url(' + audio.poster + ');"><button type="submit" class="bg-none border-0 text-light audio-play" data-id="' + audio.id + '"><span id="play-' + audio.id + '"><i class="material-icons" style="font-size: 45px;">play_arrow</i></span><span id="pause-' + audio.id + '" data-id="' + audio.id + '" style="display: none;"><i class="material-icons" style="font-size: 45px;">pause</i></span></button></div></div>';
							var info = '<div class="col-8"><div class="p-3 text-light" id="audio-name-' + audio.id + '"> ' + audio.title + '</div>';
							info += '<span class="btn badge btn-theme float-right mr-2">Добавить </span></div>';
							var bodyEnd = '</div></li>';
							
							$('#audio-list').append(body + poster + info + bodyEnd);
							
						});
					}
					else
					{
						alerts.html(json.comment).addClass('alert alert-danger');
					}
				},
				error: function(xhr, ajaxOptions, thrownError) {
	            	alert(thrownError + "\r\n" + xhr.statusText + "\r\n " + xhr.responseText);
	            },
			});
		}
		getMyPL();
		
	});
	
	</script>
	<div id="alerts"></div>
	<div id="response"></div>
	
</div>
<div class="col-lg-4"></div>
<?php
require_once ROOT.'/system/footer.php';
?>