<?php 
require_once $_SERVER['DOCUMENT_ROOT'].'/system/App.php';
$titleHeader = $title = 'Чат';
require_once ROOT.'/system/header.php';
?>
<div class="col-sm"></div>
<div class="col-sm-8 col-md-6 col-lg-4">
	
	<nav class="d-none" aria-label="breadcrumb">
		<ol class="breadcrumb">
			<div class="b-item">
				<li class="breadcrumb-item">
					<a href="/">На главную</a>
				</li>
				<li class="breadcrumb-item active" aria-current="page"><?=$title?></li>
			</div>
		</ol>
	</nav>
	
	<script type="text/javascript">
	$(document).ready(function () {
		var alerts = $('#alerts');
		var response = $('#response');
		var offset = 0;
		var count = 50;
		var timestap = null;
		var me_id = '<?=$me['id']?>';
		var button = $('#okButton');
		
		function getMessages()
		{
			$.ajax({
				url: '/AJAX/chat/getMessages.php',
				type: 'POST',
				data: {'offset': offset, 'count': count},
				dataType: 'json',
				success: function(json) {
					
					if (json.success)
					{
						if (json.response.length < 5) response.height($(window).height() - 210);
						
						response.html('');
						
						json['response'].forEach(function(chat) {
							var media = '<div class="media mb-4">';
							var left = '<div class="media-left"><div class="list-user-avatar" style="margin-top: -5px; margin-right: 10px; width: 37.5px; height: 37.5px; background-image: url(' + chat.user_avatar + ');"></div></div>';
							var right = '<div class="media-right"><div class="list-user-avatar" style="margin-top: -5px; margin-left: 5px; width: 37.5px; height: 37.5px; background-image: url(' + chat.user_avatar + ');"></div></div>';
							var leftBody = '<div class="media-body"><small class="message w-100">' + chat.message + '</small></div>';
							var rightBody = '<div class="media-body"><small class="message out w-100">' + chat.message + '</small></div>';
							var mediaEnd = '</div>';
							
							if (me_id != chat.user_id)
							{
								response.append(media + left + leftBody + mediaEnd);
							}
							else
							{
								response.append(media + rightBody + right + mediaEnd);
							}
						});
					}
					else
					{
						alerts.addClass('alert alert-danger');
						alerts.html(json['comment']);
					}
				},
				error: function(xhr, ajaxOptions, thrownError)
				{
					alert(thrownError + "\r\n" + xhr.statusText + "\r\n " + xhr.responseText);
				},
				complete: function() {
					setTimeout(function() { 
						response.scrollTop = 9999;
						// alert(response.prop('scrollHeight'));
					}, 100);
				}
			});
		}
		
		function checkNewMessages()
		{
			$.ajax({
				url: '/AJAX/chat/checkNewMessages.php?timestamp=' + timestap,
				type: 'GET',
				async: true,
				cache: false,
				success: function(data)
				{
					var json = JSON.parse(data);
					timestap = json.timestap;
					
					response.html(json.comment);
					
					setTimeout('checkNewMessages();', 2000);
				},
				error: function(xhr, ajaxOptions, thrownError)
				{
					setTimeout('checkNewMessages();', 15000);
				}
			});
		}

		// checkNewMessages();
		
		function sendMessage()
		{
			button.on('click', function(e) {
				e.preventDefault();
				
				var sendData = {
					message: $('#message').val()
				};
				
				$.ajax({
					url: '/AJAX/chat/sendMessage.php',
					type: 'POST',
					data: sendData,
					dataType: 'json',
					success: function(json)
					{
						if (json.success)
						{
							alerts.addClass('alert alert-success');
							alerts.html(json.comment);
						}
						else
						{
							alerts.addClass('alert alert-danger');
							alerts.html(json.comment);
						}
						
						setTimeout(function() {
							alerts.removeClass();
							alerts.html('');
						}, 2000);
					},
					error: function(xhr, ajaxOptions, thrownError)
					{
						alert(thrownError + "\r\n" + xhr.statusText + "\r\n " + xhr.responseText);
					},
					complete: function()
					{
						getMessages();
					}
				});
			});
		}
		getMessages();
		
		sendMessage();
	});
	</script>
	
	<div id="alerts" style="/* width: calc(100% - 30px); */ position: fixed;  z-index: 1; top: 60px; right: 10px; opacity: .8;"></div>
	
	<div class="card bg-none bs-none" style="margin-left: -15px; margin-right: -15px; margin-top: -30px;">
		<div class="card-body" id="response">
		</div>
		<div class="send-form">
			<div class="form-row">
				<div class="col-1">
					<button type="submit" class="btn btn-theme-link float-left p-0" id="smiles">
						<i class="material-icons md-24">sentiment_satisfied</i>
					</button>
				</div>
				<div class="col-10">
					<input type="text" class="form-control input-non" id="message" placeholder="Введите сообщение...">
				</div>
				<div class="col-1">
					<button type="submit" class="btn btn-theme-link float-right p-0" id="okButton">
						<i class="material-icons md-24">send</i>
					</button>
				</div>
			</div>
		</div>
	</div>
</div>
<div class="col-sm"></div>
 <?php
// require ROOT.'/system/footer.php';
 ?>